package com.omni.ads.examples.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscommunal.AdsConfigReq;
import com.omni.ads.model.adscommunal.AdsConfigResp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 根据配置类型获取配置项
 */
public class V3QueryData {

    public ResultDto<Map<String, Object>> queryData() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        Map<String, Object> map = new HashMap<>();
        map.put("endTime", 20210531);
        map.put("beginTime", 20210401);
        map.put("timeLevel", "day");
        Map<String, Object> son = new HashMap<>();
        son.put("filter_zero", 0);
        map.put("paraMap", son);
        ResultDto<Map<String, Object>> res = omniAds.adsData().v3SummaryQueryAdData(map);
        return res;
    }

    public static void main(String[] args) {
        try {
            V3QueryData entity = new V3QueryData();
            ResultDto<Map<String, Object>> response = entity.queryData();
            System.out.println(response.getData().getClass());
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

