package com.omni.ads.examples.group;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.AdsAdDataResp;
import com.omni.ads.model.adscreativity.vo.HttpPage;
import com.omni.ads.model.adsgroup.AdsCommunalGroupVo;
import com.omni.ads.model.adsgroup.AdsGroupAddForm;
import com.omni.ads.model.adsgroup.AdsGroupListForm;
import com.omni.ads.utils.DateUtils;

public class AddAdgroups {

    /**
     * AdsGroupAddForm data 必传参数
     * 1.String adGroupName 广告组名称，长度为1-100个字符
     * 2.Long planId        计划ID
     * 3.String pageUrl     广告h5落地链接（链接,应用,快应用推广同样作用）选择下载浮层或者F版的落地链接类型，需要将当前广告的目标落地链接URLencode之后，组装在下载浮层的URL地址后面，链接推广、快应用推广时必填。若为萤火虫应用下载模板页，则传递模板url，可通/v3/communal/h5Template/list接口获取模板id和url，也可参考《典型场景举例-新建应用下载模板页广告组》
     * 4.Integer extensionType  标的物类型 1：链接推广 2：应用推广 3: 快应用推广"
     * 5.Integer extensionFlow  推广流量：1-全流量场景，2-自有流量，3-联盟流量
     * 6.Integer flowScene      流量场景：1-全流量场景，2-精选推荐，3-安装有礼，4-开机必备，5-搜索，6-信息流，7-Banner，8-开屏，9-插屏，10-原生，11-激励视频，12-联盟通投
     * 7.Integer dayLimit       推广日期限制 0-不限制推广日期 1-限制推广日期，当为1时，beginTime和endTime必传
     * 推广开始时间 Integer beginTime 格式：YYYYMMDD
     * 推广截止时间 Integer endTime   格式：YYYYMMDD
     * 8.Integer billingType    计费方式.1:CPD 2:CPC 3:CPM 4:CPS 5:OCPC 6:CPA
     */
    public ResultDto<AdsCommunalGroupVo> v3GroupAdd() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        AdsGroupAddForm data = new AdsGroupAddForm();
        data.setPlanId(200295544L);
        data.setExtensionFlow(2);
        data.setExtensionType(2);
        data.setFlowScene(6);
        data.setAdGroupName("测");
        data.setDayLimit(1);
        data.setBeginTime(20240615);
        data.setEndTime(20240715);
        data.setAppId(12017359L);
        data.setPageType(11);
        data.setPageId(1022003L);
        data.setPageUrl("https://adsfs.heytapimage.com/marketing/template/adx/C/index.html?im=$im1$&btnFlag=1&pkg=com.taobao.taobao");
        data.setBillingType(5);
        data.setPrice(120);
        data.setOcpcType(12);
        data.setOcpcPrice(1300);
        // 设置必要参数  data.setxxx 详情见文档
        ResultDto<AdsCommunalGroupVo> res = omniAds.adsGroup().v3GroupAdd(data);
        return res;
    }

    public ResultDto<HttpPage<AdsAdDataResp>> v3GroupPage() throws Exception {
        AdsGroupListForm data = new AdsGroupListForm();
        data.setPage(1);
        data.setLimit(5);
        return TestConfig.getOmniAPI().adsGroup().v3GroupPage(data);
    }

    public static void main(String[] args) {
        try {
            AddAdgroups addAdgroups = new AddAdgroups();
            ResultDto<HttpPage<AdsAdDataResp>> resultDto = addAdgroups.v3GroupPage();
            System.out.println(JSON.toJSONString(resultDto, SerializerFeature.PrettyFormat));
            ResultDto<AdsCommunalGroupVo> response = addAdgroups.v3GroupAdd();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

