package com.omni.ads.examples.group;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.examples.communal.V3CommunalConfigGetList;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscommunal.AdsConfigReq;
import com.omni.ads.model.adsgroup.AdsBatchGroupStatusForm;
import com.omni.ads.model.adsgroup.AdsGroupUpdateInfo;

import java.util.ArrayList;
import java.util.List;

public class V3GroupStatus {

    public ResultDto<List<AdsGroupUpdateInfo>> v3GroupStatus() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        AdsBatchGroupStatusForm data = new AdsBatchGroupStatusForm();
        data.setStatus2(1);
        List<Long> longList = new ArrayList<>();
        longList.add(300088219L);
        longList.add(300088218L);
        data.setGroupIds(longList);
        ResultDto<List<AdsGroupUpdateInfo>> res = omniAds.adsGroup().v3GroupStatus(data);
        return res;
    }
    public static void main(String[] args) {
        try {
            V3GroupStatus entity = new V3GroupStatus();
            ResultDto<List<AdsGroupUpdateInfo>> response = entity.v3GroupStatus();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
