package com.omni.ads.examples.keyword;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adssearchkeyword.AddCustomKwPkgForm;
import com.omni.ads.model.adssearchkeyword.PkgKeywordForm;

import java.util.ArrayList;
import java.util.List;

public class V3AddCustomOrNoKwPkg {

    public ResultDto<Void> v3AddCustomOrNoKwPkg() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        AddCustomKwPkgForm data = new AddCustomKwPkgForm();
        data.setKwPackageName("twoPackage");
        data.setKwPackageType(1);
        List<PkgKeywordForm> list = new ArrayList<>();
        PkgKeywordForm ee = new PkgKeywordForm();
        ee.setKeyword("nihaoma");
        //ee.setMatchType(1);
        list.add(ee);
        data.setPkgKeywords(list);
        ResultDto<Void> res = omniAds.adsSearchKeyWord().v3AddCustomOrNoKwPkg(data);
        return res;
    }

    public static void main(String[] args) {
        try {
            V3AddCustomOrNoKwPkg entity = new V3AddCustomOrNoKwPkg();
            ResultDto<Void> response = entity.v3AddCustomOrNoKwPkg();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
