package com.omni.ads.examples.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;


import java.util.HashMap;
import java.util.Map;


public class V3MaterialCommunalQuery {

    public ResultDto<Object> v3MaterialCommunalQuery() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        Map<String, Object> map = new HashMap<>();
        map.put("materialName", "淘寶");
        map.put("ownerId", 1100018542);
        map.put("pageNum", 1);
        map.put("pageSize", 10);
        ResultDto<Object> res = omniAds.adsMaterial().v3MaterialCommunalQuery(map);
        return res;
    }
    public static void main(String[] args) {
        try {
            V3MaterialCommunalQuery entity = new V3MaterialCommunalQuery();
            ResultDto<Object> response = entity.v3MaterialCommunalQuery();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}


