package com.omni.ads.examples.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.material.AdsMtFileForm;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * 根据配置类型获取配置项
 */
public class V3MaterialUpload {

    public ResultDto<Object> queryData() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        AdsMtFileForm adsMtFileForm = new AdsMtFileForm();
        String url = "C:\\picture\\pic\\10.png";
        File files = new File(url);
        InputStream input = new FileInputStream(files);
        MultipartFile file = new MockMultipartFile(files.getName(), files.getName(),
                "multipart/form-data", input);
        adsMtFileForm.setFiles(file);
        adsMtFileForm.setMatSpecId("60");
        adsMtFileForm.setUrl(url);

        ResultDto<Object> res = omniAds.adsMaterial().v3MaterialCommunalUpload(adsMtFileForm);
        return res;
    }

    public static void main(String[] args) {
        try {
            V3MaterialUpload entity = new V3MaterialUpload();
            ResultDto<Object> response = entity.queryData();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

