package com.omni.ads.examples.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.omni.ads.baseconfig.OmniAds;
import com.omni.ads.baseconfig.ResultDto;
import com.omni.ads.examples.TestConfig;
import com.omni.ads.exception.OmniAdsResponseException;
import com.omni.ads.model.adscreativity.AdsAdDataResp;
import com.omni.ads.model.adscreativity.vo.HttpPage;
import com.omni.ads.model.adsplan.AdsPlanAddForm;
import com.omni.ads.model.adsplan.AdsPlanAddResp;
import com.omni.ads.model.adsplan.AdsPlanDataReq;
import com.omni.ads.model.adsplan.AdsPlanDataResp;

public class PlanExample {

    public ResultDto<HttpPage<AdsAdDataResp>> getAdPlan() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        AdsPlanDataReq data = new AdsPlanDataReq();
        data.setPage(1);
        data.setLimit(2);
        ResultDto<HttpPage<AdsAdDataResp>> adsPlan = omniAds.adsPlan().v3PlanPage(data);
        return adsPlan;
    }

    public ResultDto<AdsPlanAddResp> addPlan() throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        AdsPlanAddForm planForm = new AdsPlanAddForm();
        planForm.setPlanName("创建一个测试计划");
        planForm.setExtensionType(2);
        planForm.setDayLimit(1);
        planForm.setDayBudget(45600L);
        ResultDto<AdsPlanAddResp> adsPlan = omniAds.adsPlan().v3PlanAdd(planForm);
        return adsPlan;
    }

    public ResultDto<AdsPlanDataResp> getPlan(Long planId) throws Exception {
        OmniAds omniAds = TestConfig.getOmniAPI();
        //设置必要参数  data.setxxx 详情见文档
        ResultDto<AdsPlanDataResp> adsPlan = omniAds.adsPlan().v3PlanGet(planId);
        return adsPlan;
    }

    public static void main(String[] args) {
        try {
            PlanExample getAdPlan = new PlanExample();
            ResultDto<AdsPlanAddResp> resultDto = getAdPlan.addPlan();
            System.out.println(JSON.toJSONString(resultDto, SerializerFeature.PrettyFormat));

            ResultDto<AdsPlanDataResp> plan = getAdPlan.getPlan(200295543L);
            System.out.println(JSON.toJSONString(plan, SerializerFeature.PrettyFormat));

            ResultDto<HttpPage<AdsAdDataResp>> response = getAdPlan.getAdPlan();
            System.out.println(JSON.toJSONString(response, SerializerFeature.PrettyFormat));
        } catch (OmniAdsResponseException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
