package com.omni.ads.guice;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import com.omni.ads.anno.AuthInfoAppend;
import com.omni.ads.guice.interceptors.AuthInterceptor;

public class GuiceModule extends AbstractModule {

  @Override
  protected void configure() {
    bindInterceptor(
        Matchers.annotatedWith(AuthInfoAppend.class), Matchers.any(), new AuthInterceptor());
  }

}
