package com.omni.ads.guice.interceptors;


import com.omni.ads.baseconfig.ApiClient;
import com.omni.ads.baseconfig.Configuration;
import com.omni.ads.anno.NoInterceptor;
import com.omni.ads.auth.ApiKeyAuth;
import com.omni.ads.utils.DigestUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import java.util.UUID;

public class AuthInterceptor implements MethodInterceptor {

  private static ApiClient defaultApiClient = Configuration.getDefaultApiClient();

  @Override
  public Object invoke(MethodInvocation invocation) throws Throwable {
    if (invocation.getMethod().isAnnotationPresent(NoInterceptor.class)) {
      Object ret = invocation.proceed();
      return ret;
    }
    ApiKeyAuth nonce = (ApiKeyAuth) defaultApiClient.getAuthentication("nonce");
    nonce.setApiKey(DigestUtils.encrypt(UUID.randomUUID().toString()));
    ApiKeyAuth timestamp = (ApiKeyAuth) defaultApiClient.getAuthentication("timestamp");
    timestamp.setApiKey(String.valueOf(System.currentTimeMillis() / 1000));

    Object ret = invocation.proceed();
    return ret;
  }
}
