package com.omni.ads.model.adsagency;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.io.Serializable;

/**
 * 账务流水查询条件
 * @author 80122172
 *
 */

@ApiModel("账务流水查询条件")
public class AdsAccBillHisForm implements Serializable {
	/**
	 * 查询开始时间
	 */
	private Long startTime; // 开始时间


	/**
	 *  查询结束时间
	 */
	private Long endTime; // 结束时间

	/**
	 *  从账号广告主ID(代理商可以用)
	 */
	private Integer ownerId; // 客户广告主ID - 只有代理商可以使用

	/**
	 *  账户类型, 0:现金账户 1:返货账户 9999:赠送账户
	 */
	private Integer subAcc; // 账户类型
	
	/**
	 * 账务类型 , 100:充值  , 200:锁定 , 201:解锁 , 300:划账
	 */
	private Integer billSub; // 流水子类型  100:充值  , 200:锁定 , 201:解锁 , 300:划账
	
	/**
	 * 流水类型, 0 : 存入  , 1 :  支出
	 */
	@Max(1)
	@Min(0)
	private Integer billType; // 账务类型  0 : 存入  , 1 :  支出

	/**
	 * 财务流水对端账户的广告主类型， 0:代理商主 1:代理商从 2:oppo开发社区  3:广告主
	 */
	@ApiParam(hidden=true)
	private Integer pOwnerType;
	
	public Integer getSubAcc() {
		return subAcc;
	}

	public void setSubAcc(Integer subAcc) {
		this.subAcc = subAcc;
	}

	public Long getStartTime() {
		return startTime;
	}

	public Long getEndTime() {
		return endTime;
	}

	public Integer getOwnerId() {
		return ownerId;
	}

	public Integer getBillSub() {
		return billSub;
	}

	public void setStartTime(Long startTime) {
		this.startTime = startTime;
	}

	public void setEndTime(Long endTime) {
		this.endTime = endTime;
	}

	public void setOwnerId(Integer ownerId) {
		this.ownerId = ownerId;
	}

	public void setBillSub(Integer billSub) {
		this.billSub = billSub;
	}

	public Integer getBillType() {
		return billType;
	}

	public void setBillType(Integer billType) {
		this.billType = billType;
	}

	public Integer getPOwnerType() {
		return pOwnerType;
	}

	public void setPOwnerType(Integer pOwnerType) {
		this.pOwnerType = pOwnerType;
	}
}
