package com.omni.ads.model.adsagency;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 
 * 账户余额/预算/锁定金额
 * 
 * @author 80122172
 *
 */

@ApiModel(value = "账户余额/预算/锁定金额")
public class AdsBalanceVo implements Serializable {
	
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(name = "accId", value = "财务ID")
	private Integer accId;

	@ApiModelProperty(name = "cashBal", value = "现金余额(分)")
	private Long cashBal;

	@ApiModelProperty(name = "cashDayBudget", value = "现金账户日预算(分)")
	private Long cashDayBudget;

	@ApiModelProperty(name = "cashLockBal", value = "现金账户锁定余额(分)")
	private Long cashLockBal;

	@ApiModelProperty(name = "cashCost", value = "现金账户消耗(分)")
	private Long cashCost;

	@ApiModelProperty(name = "rebateDayBudget", value = "返回账户日预算(分)")
	private Long rebateDayBudget;

	@ApiModelProperty(name = "rebateBal", value = "返回账户余额(分)")
	private Long rebateBal;

	@ApiModelProperty(name = "rebateCost", value = "返回账户消耗(分)")
	private Long rebateCost;

	@ApiModelProperty(name = "virBal", value = "虚拟账户金额(分)")
    private Long virBal;

	@ApiModelProperty(hidden = true)
    private Long virDayBudget;// 赠送日预算

	@ApiModelProperty(name = "virCost", value = "虚拟账号消耗(分)")
    private Long virCost;

	@ApiModelProperty(hidden = true)
	private Long accDayBudget;

	@ApiModelProperty(value ="预算类型，0：日预算-不限 1-限制")
	private Integer budgetType = 1; //

	@ApiModelProperty(name = "accDayBudgetLimit", value = "账户日预算最低限制(分)")
	private Long accDayBudgetLimit;

	@ApiModelProperty(name = "totalBalance", value = "总余额值: virBal[赠送余额] + rebateBal[返货余额] + cashBal[现金余额]")
	private Long totalBalance;

	@ApiModelProperty(name = "lastDayCost", value ="昨日消耗")
	private Long lastDayCost;

	@ApiModelProperty(name = "todayTotalCost", value ="今日总消耗")
	private Long todayTotalCost;

	@ApiModelProperty(name = "todayConsumeRate", value ="今日总消耗占比今日总预算比例i.e. 10.21%，如无预算设置为-")
	private String todayConsumeRate;

	public Integer getBudgetType() {
		return budgetType;
	}

	public void setBudgetType(Integer budgetType) {
		this.budgetType = budgetType;
	}

	public Long getAccDayBudgetLimit() {
		return accDayBudgetLimit;
	}

	public void setAccDayBudgetLimit(Long accDayBudgetLimit) {
		this.accDayBudgetLimit = accDayBudgetLimit;
	}

	private transient String updateNums;//修改次数
    
	public String getUpdateNums() {
		return updateNums;
	}

	public void setUpdateNums(String updateNums) {
		this.updateNums = updateNums;
	}

	public Long getAccDayBudget() {
		return accDayBudget;
	}

	public void setAccDayBudget(Long accDayBudget) {
		this.accDayBudget = accDayBudget;
	}

	public Integer getAccId() {
		return accId;
	}

	public Long getCashBal() {
		return cashBal;
	}

	public Long getCashDayBudget() {
		return cashDayBudget;
	}

	public Long getCashLockBal() {
		return cashLockBal;
	}

	public Long getCashCost() {
		return cashCost;
	}

	public Long getRebateDayBudget() {
		return rebateDayBudget;
	}

	public Long getRebateBal() {
		return rebateBal;
	}

	public Long getRebateCost() {
		return rebateCost;
	}

	public Long getVirBal() {
		return virBal;
	}

	public Long getVirDayBudget() {
		return virDayBudget;
	}

	public Long getVirCost() {
		return virCost;
	}

	public void setAccId(Integer accId) {
		this.accId = accId;
	}

	public void setCashBal(Long cashBal) {
		this.cashBal = cashBal;
	}

	public void setCashDayBudget(Long cashDayBudget) {
		this.cashDayBudget = cashDayBudget;
	}

	public void setCashLockBal(Long cashLockBal) {
		this.cashLockBal = cashLockBal;
	}

	public void setCashCost(Long cashCost) {
		this.cashCost = cashCost;
	}

	public void setRebateDayBudget(Long rebateDayBudget) {
		this.rebateDayBudget = rebateDayBudget;
	}

	public void setRebateBal(Long rebateBal) {
		this.rebateBal = rebateBal;
	}

	public void setRebateCost(Long rebateCost) {
		this.rebateCost = rebateCost;
	}

	public void setVirBal(Long virBal) {
		this.virBal = virBal;
	}

	public void setVirDayBudget(Long virDayBudget) {
		this.virDayBudget = virDayBudget;
	}

	public void setVirCost(Long virCost) {
		this.virCost = virCost;
	}

	public Long getTotalBalance() {
		return totalBalance;
	}

	public void setTotalBalance(Long totalBalance) {
		this.totalBalance = totalBalance;
	}

	public Long getLastDayCost() {
		return lastDayCost;
	}

	public void setLastDayCost(Long lastDayCost) {
		this.lastDayCost = lastDayCost;
	}

	public Long getTodayTotalCost() {
		return todayTotalCost;
	}

	public void setTodayTotalCost(Long todayTotalCost) {
		this.todayTotalCost = todayTotalCost;
	}

	public String getTodayConsumeRate() {
		return todayConsumeRate;
	}

	public void setTodayConsumeRate(String todayConsumeRate) {
		this.todayConsumeRate = todayConsumeRate;
	}


}
