package com.omni.ads.model.adsagency;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;


@ApiModel(value = "customer list 请求参数")
public class CustomerListReq {

    /**
     *  操作用户id
     */
    private Long operatorId;


    /**
     *  操作用户名
     */
    private String operatorName;

    /**
     *  过滤条件，查询当前代理商下的广告主类型
      */
    private Integer ownerType;

    /**
     * 广告主ID
     */
    @ApiParam(name = "ownerId", type = "Long", value = "当前登陆代理商的广告主ID")
    Long ownerId;

    /**
     * 广告主名称
     */
    @ApiParam(name = "ownerName", value = "广告主名称", type = "String")
    String ownerName;

    /**
     * 审核状态, 0: 未审核 1：审核通过 2：审核未通过
     */
    @ApiParam(name = "auditStatus", type = "Integer", value = "审核状态, 0: 未审核 1：审核通过 2：审核未通过")
    @Max(2)
    @Min(0)
    Integer auditStatus;

    /**
     * 当前页
     */
    @ApiParam(name = "page", type = "Integer",value = "当前页", required = true)
    @NotNull
    Integer page;

    /**
     * 每页数量
     */
    @ApiParam(name = "pageCount", type = "Integer",value = "每页数量", required = true)
    @NotNull
    Integer pageCount;

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Integer getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(Integer ownerType) {
        this.ownerType = ownerType;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageCount() {
        return pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }
}
