package com.omni.ads.model.adsagency;

import com.google.common.base.Splitter;

/**
 * @author 80204975
 * @date 2018/6/12 15:46
 */
public class WebConst {

	public static final int DATA_QUERY_MAX_COUNT = 100; // 数据查询服务一次最多查询数量
	public static final int QRY_APP_INFO_ERROR = 1; // 查询app信息异常
	public static final int QRY_APP_INFO_NORMAL = 0; // 查询app信息正常
	public static final int DEFAULT_MODIFY_LIMIT = 10; // 默认修改次数限制

	public static final int NO_GAME_REG_AUTH = 0;
	public static final int HAS_GAME_REG_AUTH = 1;

	// 显示常量
	public static final String BUDGET_UNLIMIT = "不限额";
	public static final String DELETE = "已删除";

	public static final String COMMA = ",";
	public static final char NAME_SPLIT = '_';
	public static final char KEY_SPLIT = ':';
	public static final char NAME_SHEET_SPLIT = '-';
	
	public static final int ALL = -1;	//所有
	public static final int DEL = 1;	//已删除
	public static final int UNDEL= 0;	//未删除
	
	public interface LIMIT {
		int DAY_BUDGET_NOT_LIMIT = 0; // 不限日限额
		int DAY_BUDGET_LIMIT = 1; // 有日限额
		int GROUP_DAY_UNLIMIT = 0; // 不限广告组推广日期
		int GROUP_DAY_LIMIT = 1; // 限制广告组推广日期
		int GROUP_TIME_UNLIMIT = 0; // 不限制广告组播放时段
		int GROUP_TIME_LIMIT = 1; // 限制广告组播放时段
	}

	public interface LoginType {
		int LOGIN_TYPE_AGENCY_ONLY = 1; // 代理商登入
		int LOGIN_TYPE_SUBOWNER_AGENCY = 2; // 代理商登入子账户
		int LOGIN_TYPE_SUBOWNER_SELF = 3; // 子账户自己登入
		int LOGIN_TYPE_DIRECTED_OWNER = 4; // 直客登入
		int LOGIN_TYPE_AGENCY_OPERATOR = 5; // 运营登入
	}

	public interface AccType {
		int ACC_TYPE_CASH = 0;
		int ACC_TYPE_REBATE = 1;
		int ACC_TYPE_VIR = 9999;
	}

	public interface AccDayBudgetType {
		int ACC_DAY_BUDGET_NO_LIMIT = 0;  // 账户日预算  不限
		int ACC_DAY_BUDGET_HAS_LIMIT = 1;  // 账户日预算  限制
	}

	public interface OperateType {
		int delete = 0;
		int price = 1;			// 广告组修改占用了此类型
		int start = 2;
		int pause = 3;
		int ocpcPrice = 4; 		// group ocpcPrice
		int deepOcpcPrice = 5; 	// group deepOcpcPrice
		int groupPrice = 6;		// group price
	}

	/**
	 * 账务流水子类型
	 * 
	 * @author 80122172
	 *
	 */
	public interface AccBillSub {
		int BILL_SUB_DEPOSIT = 100;
		int BILL_SUB_LOCK = 200;
		int BILL_SUB_UNLOCK = 201;
		int BILL_SUB_REMIT = 300;
	}

	/**
	 * 账务类型
	 * 
	 * @author 80122172
	 */
	public interface AccBillType {
		int BILL_TYPE_DEPOSIT = 0;
		int BILL_TYPE_EXPAND = 1;
	}

	public interface Splliter {
		public static final Splitter SPLITTER_COMMA = Splitter.on(",").trimResults().omitEmptyStrings();
		public static final Splitter SPLITTER_COLON = Splitter.on(":").trimResults().omitEmptyStrings();
	}

	public interface ImeiExport {
		public static final String IMEI_EP_OWNER_OPR_SECONDS = "imei_ep_owner_opr_seconds";
		
		public static final String IMEI_LIMIT_EXPORT_SWITCH = "imei_extract_limit_export_switch";

		public static final String IMEI_API_EXPORT_LIMIT_COUNT = "imei_api_export_limit_count";
	}

	/**
	 * 是
	 */
	public static final int IS_Y = 1;


	//新增动态配置用于opr_log使用column使用，并非直接通过表名来设置- 账务修改日预算需求 [临时解决方案]
	public interface OprLog {
		public static final String DAY_BUDGET= "day_budget";
	}

	/**
	 * API文档类型
	 *
	 * @author 80122172
	 */
	public interface FileType {
		int JS_API = 6;
		int H5_API = 7;
	}

	/**
	 * 标签生成类型
	 */
	public interface TagType {
		int DMP_TAG_AUDIENCE = 0;
		int DMP_TAG_CALC = 1;
	}
	
	public interface AdFlag{
        public static  final  int AD_2_0 = 2;  //0-默认为旧版本
        public static  final  int AD_3_0 = 3;  //1-融合3.0版本
        public static  final  int AD_2_0_AND_3_0  = 4;  //默认和3.0
	}

	//听风监控常量  营销平台诊断服务请求记录
	public static final String MARKETING_DIAGNOSE_REQUEST_COUNT = "marketing_diagnose_request_count";

	/**
	 * 应用分类
	 */
	public interface AppCategory {
		int GAME = 8;
	}

	/**
	 * 快应用分类
	 */
	public interface InstantAppType {
		byte APP = 1;// 应用
		byte GAME = 2;// 游戏
		byte LIGHT_GAME = 3;// 轻游戏
		byte H5 = 4;// H5链接
	}
}
