/**
 * Copyright (c) 2018 OPPO, All Rights Reserved.
 *
 * @Package com.oppo.os.ads.communal.web.entity.form
 * @author 80223788
 * @date 2018年8月22日 下午4:13:27
 */
package com.omni.ads.model.adsauth;

import io.swagger.annotations.ApiModel;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author 80223788
 *
 */
@ApiModel("参数")
public class AdsBaseForm implements Serializable {

    private static final long serialVersionUID = -3823312633300864366L;

    /**
     * 1-代理商登入;2- 代理商登入子账户;3-子账户自己登入;4-直客登入
     * 必传参数
     */
    @NotNull
    private Integer loginType;


    /**
     * 广告主ID, 当loginType为2 时， ownerId必填
     */
    private Long ownerId;

    /**
     * @return the loginType
     */
    public Integer getLoginType() {
        return loginType;
    }


    /**
     * @param loginType the loginType to set
     */
    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }


    /**
     * 判断是否代理商登陆（非代理商登陆子账号）
     */
    public boolean isAgencyLogin() {
        if (loginType != null && (loginType == 1 || loginType == 5)) {
            return true;
        } else {
            return false;
        }
    }


}
