package com.omni.ads.model.adscommunal;


import java.io.Serializable;

public class AdsAdPageForm implements Serializable {

    /**
     * 落地页id
     * @ignore
     */
    private String pageId;
    /**
     * 落地页url
     * 与 pageType 不能同时为空
     */
    private String pageUrl;
    /**
     * 建站类型
     * 与 pageUrl 不能同时为空
     * <p>
     * 0-自定义落地页
     * 1-一叶智能
     * 2-云脑建站
     * 3-达尔文建站
     * 4-萤火虫建站
     * 5-快应用建站
     * 6-广告主自建页面 JS SDK
     * 7-广告主自建页面 H5 API 回传
     * 8-信息流 线索直达
     * 9-商店详情页
     * 11-萤火虫应用模板下载页
     * 12-互动落地页
     *
     */
    private Integer pageType;
    /**
     * 应用id
     * <p>
     * 适用于应用推广场景，起校验作用，传入appId参数确保只返回该应用的落地页
     * 不能单独使用，需要与pageType、pageUrl配合使用
     */
    private String appId;

    public AdsAdPageForm() {
    }

    public String getPageId() {
        return pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPageUrl() {
        return pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

}
