package com.omni.ads.model.adscommunal;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import java.io.Serializable;
import java.util.List;

/**
 * <p>title: 元数据配置查询参数</p>
 * <p>Description: </p>
 * <p>Copyright (c) 2020 www.oppo.com Inc. All rights reserved.</p>
 * <p>Company: OPPO</p>
 *
 * @author Eden
 * @since 2020/12/28
 */
@ApiModel("元数据配置查询请求对象")
public class AdsConfigReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "配置类型，获取配置列表，配置类型不能为空，EXTENSION_TYPE：推广目的，EXTENSION_FLOW：推广流量，FLOW_SCENE：流量场景，BILLING_TYPE：出价方式，OCPC_TYPE：转化类型，DEEP_OCPC_TYPE：深度转化类型，SPEC_TYPE：规格，URL_TYPE：监测链接，SMART_EXPAND_TYPE；智能拓量，FIREFLY_APP_DOWN_PAGE：萤火虫应用下载页，PAGE_TYPE：落地页类型，REQUIRED_SPEC_TYPE：全流量必填规格")
    private String type;

    @ApiParam(value = "配置类型列表，批量获取配置项，配置类型列表不能为空，EXTENSION_TYPE：推广目的，EXTENSION_FLOW：推广流量，FLOW_SCENE：流量场景，BILLING_TYPE：出价方式，OCPC_TYPE：转化类型，DEEP_OCPC_TYPE：深度转化类型，SPEC_TYPE：规格，URL_TYPE：监测链接，SMART_EXPAND_TYPE；智能拓量，FIREFLY_APP_DOWN_PAGE：萤火虫应用下载页，PAGE_TYPE：落地页类型，REQUIRED_SPEC_TYPE：全流量必填规格")
    private List<String> typeList;

    @ApiParam(value = "推广目标 1：链接推广 2：应用推广 3: 快应用推广", required = false)
    @AdRange(values = {1, 2, 3}, message = "extensionType取值范围为1、2、3")
    private Integer extensionType;

    @ApiParam(value = "推广流量：1-全流量场景，2-自有流量，3-联盟流量", required = false)
    @AdRange(values = {1, 2, 3}, message = "extensionFlow取值范围为1、2、3")
    private Integer extensionFlow;

    @ApiParam(value = "流量场景：1-全流量场景，2-精选推广，3-安装有礼，4-开机必备，5-搜索，6-信息流，7-Banner，8-开屏，9-插屏，10-原生，11-激励视频，12-联盟通投。修改出价，流量场景不能为空", required = false)
    @AdRange(values = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, message = "flowScene取值范围为1~12")
    private Integer flowScene;


    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getTypeList() {
        return typeList;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Integer getExtensionFlow() {
        return extensionFlow;
    }

    public void setExtensionFlow(Integer extensionFlow) {
        this.extensionFlow = extensionFlow;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }
}
