package com.omni.ads.model.adscommunal;

import com.omni.ads.model.adscreativity.vo.Groups;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

public class AdsV3MtrSpecForm implements Serializable {

    private static final long serialVersionUID = -768147588418330490L;

    /**
     * 推广类型
     * 1.链接推广
     * 2.应用推广
     * 3.快应用
     *
     *
     */
    @NotNull(groups = {Groups.Query.class}, message = "推广类型不能为空")
    private Integer extensionType;

    /**
     * 推广流量
     * 1.全流量场景
     * 2.自有流量
     * 3.联盟流量
     *
     *
     */
    @NotNull(groups = {Groups.Query.class}, message = "推广流量不能为空")
    private Integer extensionFlow;


    /**
     * 流量场景
     * 1.全流量场景
     * 2.精选推广
     * 3.安装有礼
     * 4.开机必备
     * 5.搜索
     * 6.信息流
     * 7.banner
     * 8.开屏
     * 9.插屏
     * 10.原生
     * 11.激励视频
     * 12.通投类型
     * 20.品牌
     *
     */
    @NotNull(groups = {Groups.Query.class}, message = "流量场景不能为空")
    private Integer flowScene;

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Integer getExtensionFlow() {
        return extensionFlow;
    }

    public void setExtensionFlow(Integer extensionFlow) {
        this.extensionFlow = extensionFlow;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }
}
