package com.omni.ads.model.adscommunal;


import java.io.Serializable;

public class AdsV3MtrSpecVo implements Serializable {
    private static final long serialVersionUID = -768147588418330490L;
    /**
     * 规格名称
     */
    private String mSpecName;
    /**
     * 推广类型
     */
    private Integer extensionType;
    /**
     * 流量场景
     */
    private Integer flowScene;
    /**
     * 全局规格id
     */
    private Integer globalSpecId;
    /**
     * 规格详情JSON字符串
     * <p>
     * 一、外层字段：
     * TitleFmt title;// 标题格式要求
     * DescFmt desc;// 描述格式要求
     * BdNameFmt bdName;// 品牌名称格式要求
     * List<VideoFmt> videoList;// 视频格式要求
     * List<ImgFmt> imgs;// 图片格式要求集合
     * boolean repeat = false; //是否多张图片
     * Integer minImgNum;    //当repeat=true时表示限制最少minImgNum张imgs[0]指定的图片
     * Integer maxImgNum;    //当repeat=true时表示限制最多maxImgNum张imgs[0]指定的图片
     * ImgFmt brandLogo;    //品牌Logo图片.
     * TitleFmt buttonTxt;    //按钮文案.
     * ImgFmt videoBgImg;    //视频结束背景图.
     * ImgFmt videoImg;    //视频封面.
     * <p>
     * 二、内层字段：
     * TitleFmt:
     * Integer len;// 字数限制
     * Boolean need;// 是否必填
     * Integer minLen;    //字数最小值
     * Integer maxLen;    //字数最大值
     * <p>
     * DescFmt:
     * Integer len;// 字数限制
     * Boolean need;// 是否必填
     * Integer minLen;    //字数最小值
     * Integer maxLen;    //字数最大值
     * <p>
     * BdNameFmt:
     * Integer len;// 字数限制
     * Boolean need;// 是否必填
     * Integer minLen;    //字数最小值
     * Integer maxLen;    //字数最大值
     * <p>
     * VideoFmt:
     * Long maxDrt;// 最大时长，s
     * Long minDrt;// 最小时长，s
     * List<String> whSc;// 视频宽高比集合(宽：高,如16:9)
     * Integer w;// 视频宽
     * Integer h;// 视频高
     * Long s;// 视频大小
     * List<String> fmt;// 视频文件格式集合
     * <p>
     * ImgFmt:
     * Integer w;// 图片宽
     * Integer h;// 图片高
     * Float rate;// 图片宽高比(保留两位小数)
     * List<String> whSc;// 图片宽高比集合(宽：高,如16:9)
     * Long s;// 图片大小
     * List<String> fmt;// 图片文件格式集合
     * Integer titleNum;    //标题字数限制
     * Integer subTitleNum;    //副标题字数限制
     * Integer validateFlag;  //校验标识   null、1：校验   2：不校验
     * <p>
     * 示例：{"bdName":{"maxLen":8,"minLen":1},"brandLogo":{"fmt":["jpg","png","jpeg"],"h":200,"s":100,"w":200},"buttonTxt":{"maxLen":4,"minLen":1},"imgs":[],"repeat":false,"title":{"maxLen":23,"minLen":1},"videoBgImg":{"fmt":["png","jpg","jpeg"],"h":1280,"s":150,"w":720},"videoImg":{"fmt":["png","jpg","jpeg"],"h":720,"s":150,"w":1280},"videoList":[{"fmt":["mp4"],"h":0,"maxDrt":60000,"minDrt":0,"s":25600,"w":0,"whSc":["16:9"]}]}    *
     *
     *
     */
    private String format;
    /**
     * demoUrl
     */
    private String demoUrl;
    /**
     * @ignore
     */
    private String authCode;
    /**
     * 指定相关字段是否必填描述
     * 1-必填，2-选填，其他-隐藏
     * 示例：{"videoList":1,"videoImg":1,"title":1,"bdName":1,"brandLogo":1}
     */
    private String required;

    public String getmSpecName() {
        return mSpecName;
    }

    public void setmSpecName(String mSpecName) {
        this.mSpecName = mSpecName;
    }

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }

    public Integer getGlobalSpecId() {
        return globalSpecId;
    }

    public void setGlobalSpecId(Integer globalSpecId) {
        this.globalSpecId = globalSpecId;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getDemoUrl() {
        return demoUrl;
    }

    public void setDemoUrl(String demoUrl) {
        this.demoUrl = demoUrl;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getRequired() {
        return required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    @Override
    public String toString() {
        return "AdsV3MtrSpecVo{" +
                "mSpecName='" + mSpecName + '\'' +
                ", extensionType=" + extensionType +
                ", flowScene=" + flowScene +
                ", globalSpecId=" + globalSpecId +
                ", format='" + format + '\'' +
                ", demoUrl='" + demoUrl + '\'' +
                ", authCode='" + authCode + '\'' +
                '}';
    }
}
