package com.omni.ads.model.adsconfig;

import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

public class AdSearchPremiumKwSaveDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiParam(
            hidden = true
    )
    private Long id;
    @ApiParam(
            hidden = true
    )
    private Long kwPackageId;
    @ApiParam(
            value = "广告组ID",
            required = false
    )
    @NotNull(
            message = "广告组id不能为空"
    )
    @Min(
            value = 1L,
            message = "广告组id必须大于0"
    )
    private Long adGroupId;
    @ApiParam(
            value = "广告主ID",
            required = false
    )
    @NotNull(
            message = "广告主id不能为空"
    )
    private Long ownerId;
    @ApiParam(
            value = "应用ID",
            required = false
    )
    private Long appId;
    @ApiParam(
            value = "匹配类型 1:精准匹配 2:词组匹配 3:模糊匹配",
            required = false
    )
    private Integer matchType;
    @ApiParam(
            value = "出价(必须大于0)",
            required = false
    )
    @Min(
            value = 1L,
            message = "出价词价格必须大于0"
    )
    private Integer price;
    @ApiParam(value = "出价(必须大于0)", required = false)
    @Min(value = 1, message = "出价词价格必须大于0")
    private Integer ocpcPrice; //价格 (分)

    @ApiParam(value = "出价(必须大于0)", required = false)
    @Min(value = 1, message = "出价词价格必须大于0")
    private Integer deepOcpcPrice; //价格 (分)

    @ApiParam(value = "目标ROI系数 * 1000000", required = false)
    @Range(min = 0, max = 10000000, message = "targetROI取值范围为0~10000000")
    private Integer targetROI; // 目标ROI系数*1000000,目标ROI系数(0,10]，可支持到小数点后4位, 目标ROI系数=首日付费金额/广告投放成本

    @ApiParam(
            value = "来源 2:出价类目词包 5:广告主手动上传(出价词包)",
            required = false
    )

    private Integer source;
    @ApiParam(
            value = "行业类目ID(当在添加出价类目词包时必传)",
            required = false
    )
    private Long categoryId;
    @ApiParam(
            value = "关键词 or 行业类目名称",
            required = false
    )
    @NotBlank(
            message = "关键词不能为空"
    )
    @Length(
            max = 15,
            message = "关键词长度必须在[1,15]之间"
    )
    private String keyword;
    @ApiParam(
            hidden = true
    )
    private Integer auditStatus;
    @ApiParam(
            hidden = true
    )
    private String auditMsg;
    @ApiParam(
            hidden = true
    )
    private Integer kwPackageType;
    @ApiParam(
            hidden = true
    )
    @NotBlank(
            message = "操作者不能为空"
    )
    private String updateBy;
    @ApiParam(
            hidden = true
    )
    @NotBlank(
            message = "操作者ip不能为空"
    )
    private String updateHost;
    @ApiParam(
            hidden = true
    )
    private Integer deleteFlag;
    @ApiParam(
            hidden = true
    )
    private Long insertTime;
    @ApiParam(
            hidden = true
    )
    private Long lastModifyTime;

    /**
     * 系统推荐关键词月搜索量
     */
    private Long kwMonthlyPv;

    public Integer getOcpcPrice() {
        return ocpcPrice;
    }

    public void setOcpcPrice(Integer ocpcPrice) {
        this.ocpcPrice = ocpcPrice;
    }

    public Integer getDeepOcpcPrice() {
        return deepOcpcPrice;
    }

    public void setDeepOcpcPrice(Integer deepOcpcPrice) {
        this.deepOcpcPrice = deepOcpcPrice;
    }

    public Integer getTargetROI() {
        return targetROI;
    }

    public void setTargetROI(Integer targetROI) {
        this.targetROI = targetROI;
    }

    public Long getKwMonthlyPv() {
        return kwMonthlyPv;
    }

    public void setKwMonthlyPv(Long kwMonthlyPv) {
        this.kwMonthlyPv = kwMonthlyPv;
    }

    public AdSearchPremiumKwSaveDTO() {
    }

    public Long getId() {
        return this.id;
    }

    public Long getKwPackageId() {
        return this.kwPackageId;
    }

    public Long getAdGroupId() {
        return this.adGroupId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Long getAppId() {
        return this.appId;
    }

    public Integer getMatchType() {
        return this.matchType;
    }

    public Integer getPrice() {
        return this.price;
    }

    public Integer getSource() {
        return this.source;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    public String getAuditMsg() {
        return this.auditMsg;
    }

    public Integer getKwPackageType() {
        return this.kwPackageType;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public String getUpdateHost() {
        return this.updateHost;
    }

    public Integer getDeleteFlag() {
        return this.deleteFlag;
    }

    public Long getInsertTime() {
        return this.insertTime;
    }

    public Long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKwPackageId(Long kwPackageId) {
        this.kwPackageId = kwPackageId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setMatchType(Integer matchType) {
        this.matchType = matchType;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public void setKwPackageType(Integer kwPackageType) {
        this.kwPackageType = kwPackageType;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public void setUpdateHost(String updateHost) {
        this.updateHost = updateHost;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public void setInsertTime(Long insertTime) {
        this.insertTime = insertTime;
    }

    public void setLastModifyTime(Long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof AdSearchPremiumKwSaveDTO)) {
            return false;
        } else {
            AdSearchPremiumKwSaveDTO other = (AdSearchPremiumKwSaveDTO)o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                Object this$id = this.getId();
                Object other$id = other.getId();
                if (this$id == null) {
                    if (other$id != null) {
                        return false;
                    }
                } else if (!this$id.equals(other$id)) {
                    return false;
                }

                Object this$kwPackageId = this.getKwPackageId();
                Object other$kwPackageId = other.getKwPackageId();
                if (this$kwPackageId == null) {
                    if (other$kwPackageId != null) {
                        return false;
                    }
                } else if (!this$kwPackageId.equals(other$kwPackageId)) {
                    return false;
                }

                Object this$adGroupId = this.getAdGroupId();
                Object other$adGroupId = other.getAdGroupId();
                if (this$adGroupId == null) {
                    if (other$adGroupId != null) {
                        return false;
                    }
                } else if (!this$adGroupId.equals(other$adGroupId)) {
                    return false;
                }

                label206: {
                    Object this$ownerId = this.getOwnerId();
                    Object other$ownerId = other.getOwnerId();
                    if (this$ownerId == null) {
                        if (other$ownerId == null) {
                            break label206;
                        }
                    } else if (this$ownerId.equals(other$ownerId)) {
                        break label206;
                    }

                    return false;
                }

                label199: {
                    Object this$appId = this.getAppId();
                    Object other$appId = other.getAppId();
                    if (this$appId == null) {
                        if (other$appId == null) {
                            break label199;
                        }
                    } else if (this$appId.equals(other$appId)) {
                        break label199;
                    }

                    return false;
                }

                Object this$matchType = this.getMatchType();
                Object other$matchType = other.getMatchType();
                if (this$matchType == null) {
                    if (other$matchType != null) {
                        return false;
                    }
                } else if (!this$matchType.equals(other$matchType)) {
                    return false;
                }

                label185: {
                    Object this$price = this.getPrice();
                    Object other$price = other.getPrice();
                    if (this$price == null) {
                        if (other$price == null) {
                            break label185;
                        }
                    } else if (this$price.equals(other$price)) {
                        break label185;
                    }

                    return false;
                }

                label178: {
                    Object this$source = this.getSource();
                    Object other$source = other.getSource();
                    if (this$source == null) {
                        if (other$source == null) {
                            break label178;
                        }
                    } else if (this$source.equals(other$source)) {
                        break label178;
                    }

                    return false;
                }

                Object this$categoryId = this.getCategoryId();
                Object other$categoryId = other.getCategoryId();
                if (this$categoryId == null) {
                    if (other$categoryId != null) {
                        return false;
                    }
                } else if (!this$categoryId.equals(other$categoryId)) {
                    return false;
                }

                Object this$keyword = this.getKeyword();
                Object other$keyword = other.getKeyword();
                if (this$keyword == null) {
                    if (other$keyword != null) {
                        return false;
                    }
                } else if (!this$keyword.equals(other$keyword)) {
                    return false;
                }

                label157: {
                    Object this$auditStatus = this.getAuditStatus();
                    Object other$auditStatus = other.getAuditStatus();
                    if (this$auditStatus == null) {
                        if (other$auditStatus == null) {
                            break label157;
                        }
                    } else if (this$auditStatus.equals(other$auditStatus)) {
                        break label157;
                    }

                    return false;
                }

                label150: {
                    Object this$auditMsg = this.getAuditMsg();
                    Object other$auditMsg = other.getAuditMsg();
                    if (this$auditMsg == null) {
                        if (other$auditMsg == null) {
                            break label150;
                        }
                    } else if (this$auditMsg.equals(other$auditMsg)) {
                        break label150;
                    }

                    return false;
                }

                Object this$kwPackageType = this.getKwPackageType();
                Object other$kwPackageType = other.getKwPackageType();
                if (this$kwPackageType == null) {
                    if (other$kwPackageType != null) {
                        return false;
                    }
                } else if (!this$kwPackageType.equals(other$kwPackageType)) {
                    return false;
                }

                label136: {
                    Object this$updateBy = this.getUpdateBy();
                    Object other$updateBy = other.getUpdateBy();
                    if (this$updateBy == null) {
                        if (other$updateBy == null) {
                            break label136;
                        }
                    } else if (this$updateBy.equals(other$updateBy)) {
                        break label136;
                    }

                    return false;
                }

                Object this$updateHost = this.getUpdateHost();
                Object other$updateHost = other.getUpdateHost();
                if (this$updateHost == null) {
                    if (other$updateHost != null) {
                        return false;
                    }
                } else if (!this$updateHost.equals(other$updateHost)) {
                    return false;
                }

                label122: {
                    Object this$deleteFlag = this.getDeleteFlag();
                    Object other$deleteFlag = other.getDeleteFlag();
                    if (this$deleteFlag == null) {
                        if (other$deleteFlag == null) {
                            break label122;
                        }
                    } else if (this$deleteFlag.equals(other$deleteFlag)) {
                        break label122;
                    }

                    return false;
                }

                Object this$insertTime = this.getInsertTime();
                Object other$insertTime = other.getInsertTime();
                if (this$insertTime == null) {
                    if (other$insertTime != null) {
                        return false;
                    }
                } else if (!this$insertTime.equals(other$insertTime)) {
                    return false;
                }

                Object this$lastModifyTime = this.getLastModifyTime();
                Object other$lastModifyTime = other.getLastModifyTime();
                if (this$lastModifyTime == null) {
                    if (other$lastModifyTime != null) {
                        return false;
                    }
                } else if (!this$lastModifyTime.equals(other$lastModifyTime)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdSearchPremiumKwSaveDTO;
    }

    public int hashCode() {
        int result = 1;
        Object $id = this.getId();
        Object $kwPackageId = this.getKwPackageId();
        result = result * 59 + ($kwPackageId == null ? 43 : $kwPackageId.hashCode());
        Object $adGroupId = this.getAdGroupId();
        result = result * 59 + ($adGroupId == null ? 43 : $adGroupId.hashCode());
        Object $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        Object $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        Object $matchType = this.getMatchType();
        result = result * 59 + ($matchType == null ? 43 : $matchType.hashCode());
        Object $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        Object $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Object $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : $categoryId.hashCode());
        Object $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        Object $auditStatus = this.getAuditStatus();
        result = result * 59 + ($auditStatus == null ? 43 : $auditStatus.hashCode());
        Object $auditMsg = this.getAuditMsg();
        result = result * 59 + ($auditMsg == null ? 43 : $auditMsg.hashCode());
        Object $kwPackageType = this.getKwPackageType();
        result = result * 59 + ($kwPackageType == null ? 43 : $kwPackageType.hashCode());
        Object $updateBy = this.getUpdateBy();
        result = result * 59 + ($updateBy == null ? 43 : $updateBy.hashCode());
        Object $updateHost = this.getUpdateHost();
        result = result * 59 + ($updateHost == null ? 43 : $updateHost.hashCode());
        Object $deleteFlag = this.getDeleteFlag();
        result = result * 59 + ($deleteFlag == null ? 43 : $deleteFlag.hashCode());
        Object $insertTime = this.getInsertTime();
        result = result * 59 + ($insertTime == null ? 43 : $insertTime.hashCode());
        Object $lastModifyTime = this.getLastModifyTime();
        result = result * 59 + ($lastModifyTime == null ? 43 : $lastModifyTime.hashCode());
        return result;
    }

    public String toString() {
        return "AdSearchPremiumKwSaveDTO(id=" + this.getId() + ", kwPackageId=" + this.getKwPackageId() + ", adGroupId=" + this.getAdGroupId() + ", ownerId=" + this.getOwnerId() + ", appId=" + this.getAppId() + ", matchType=" + this.getMatchType() + ", price=" + this.getPrice() + ", source=" + this.getSource() + ", categoryId=" + this.getCategoryId() + ", keyword=" + this.getKeyword() + ", auditStatus=" + this.getAuditStatus() + ", auditMsg=" + this.getAuditMsg() + ", kwPackageType=" + this.getKwPackageType() + ", updateBy=" + this.getUpdateBy() + ", updateHost=" + this.getUpdateHost() + ", deleteFlag=" + this.getDeleteFlag() + ", insertTime=" + this.getInsertTime() + ", lastModifyTime=" + this.getLastModifyTime() + ")";
    }
}
