package com.omni.ads.model.adsconfig;


import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 素材
 */
public class AdsMaterialBO implements Serializable {
    private static final long serialVersionUID = 5088807364445440363L;

    /**
     * webp文件默认后缀
     */
    public static final String SHORT_WEBP_SUFFIX = ".short.webp";

    /**
     * 素材信息
     */
    private Long mId;// ID
    private Long materialId; // 素材id
    private String openMaterialId;// 外部素材ID
    private String materialUrl;// 素材URL
    private Integer width;// 宽
    private Integer height;// 高
    /**
     * 宽高比  2020年10月10日 16点02分
     */
    private String aspectRatio;
    private Integer type;// 类型: 1:图片 2:视频
    private Integer size;// 大小
    private String md5;
    private String extJson;
    private Integer insertTime;
    private Integer duration;// 时长
    private Integer updateTime; // 更新时间
    private Integer deleteFlag; // 删除标识
    private String webpMd5;// webp文件MD5
    private String webpMUrl;//webp文件Url

    // 品牌新增字段
    private String compressedUrl;//压缩文件URL
    private String compressedMd5;//压缩文件MD5
    private Integer compressedSize;//素材压缩后文件大小

    // 映射信息，建议使用@AdsMaterialMapping
    @Deprecated
    private Long ownerId;
    @Deprecated
    private Long adId;// 关联的AdId(映射表中维护)
    @Deprecated
    private Integer materialSort;// 多素材广告中素材Index(映射表中维护)

    public static AdsMaterialBO instance(Long ownerId, String openMaterialId, String materialUrl,
                                         String webpMUrl, String md5, Integer width, Integer height, String aspectRatio) {
        AdsMaterialBO bo = new AdsMaterialBO();
        bo.setOwnerId(ownerId);
        bo.setOpenMaterialId(openMaterialId);
        bo.setMaterialUrl(materialUrl);
        bo.setWebpMUrl(webpMUrl);
        bo.setMd5(md5);
        bo.setWidth(width);
        bo.setHeight(height);
        bo.setAspectRatio(aspectRatio);
        return bo;
    }

    public String getWebpMUrl() {
        return webpMUrl;
    }

    public void setWebpMUrl(String webpMUrl) {
        this.webpMUrl = webpMUrl;
    }

    public String getWebpMd5() {
        return webpMd5;
    }

    public void setWebpMd5(String webpMd5) {
        this.webpMd5 = webpMd5;
    }

    public Integer getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Integer updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Long getmId() {
        return mId;
    }

    public void setmId(Long mId) {
        this.mId = mId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getOpenMaterialId() {
        return openMaterialId;
    }

    public void setOpenMaterialId(String openMaterialId) {
        this.openMaterialId = openMaterialId;
    }

    public String getMaterialUrl() {
        return materialUrl;
    }

    public void setMaterialUrl(String materialUrl) {
        this.materialUrl = materialUrl;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }

    public Integer getInsertTime() {
        return insertTime;
    }

    public void setInsertTime(Integer insertTime) {
        this.insertTime = insertTime;
    }

    public Integer getMaterialSort() {
        return materialSort;
    }

    public void setMaterialSort(Integer materialSort) {
        this.materialSort = materialSort;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getCompressedUrl() {
        return compressedUrl;
    }

    public void setCompressedUrl(String compressedUrl) {
        this.compressedUrl = compressedUrl;
    }

    public String getCompressedMd5() {
        return compressedMd5;
    }

    public void setCompressedMd5(String compressedMd5) {
        this.compressedMd5 = compressedMd5;
    }

    public Integer getCompressedSize() {
        return compressedSize;
    }

    public void setCompressedSize(Integer compressedSize) {
        this.compressedSize = compressedSize;
    }

    public String getAspectRatio() {
        return aspectRatio;
    }

    public void setAspectRatio(String aspectRatio) {
        this.aspectRatio = aspectRatio;
    }
}
