package com.omni.ads.model.adsconfig;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 创意 - 素材映射
 */
public class AdsMaterialMapping implements Serializable {
    /**
     * 素材
     */
    private Long ownerId;
    private Long adId;// 关联的AdId(映射表中维护)
    private Long crId;    //创意id
    private Integer materialSort;// 多素材广告中素材Index(映射表中维护)

    /**
     * 映射信息
     */
    private Long itemId;    //item标识
    private Integer itemKind;   //item 类型 0 mainItem 1 . subItem
    private String title;    //标题
    private String subTitle;    //副标题
    private Integer picSizeType;    //图标类型   1、1:1类型 2、4:3类型
    private Long sparkPageId;   //建站ID
    private Integer pageType; // 落地页建站类型:1-一叶智能 2-云脑建站 3-达尔文 4-萤火虫建站 5-快应用建站 6-广告主自建页面 JS SDK 7-H5 API 回传 8-信息流线索直达
    private String targetUrl;   //目标h5地址
    private String deepLink;    //目标deeplink地址，对应搜索targetDeeplink
    private String targetInstant;
    private String extId;  //搜索itemId
    private String md5; //搜索创意的md5

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Long getCrId() {
        return crId;
    }

    public void setCrId(Long crId) {
        this.crId = crId;
    }

    public Integer getMaterialSort() {
        return materialSort;
    }

    public void setMaterialSort(Integer materialSort) {
        this.materialSort = materialSort;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public Integer getPicSizeType() {
        return picSizeType;
    }

    public void setPicSizeType(Integer picSizeType) {
        this.picSizeType = picSizeType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getItemKind() {
        return itemKind;
    }

    public void setItemKind(Integer itemKind) {
        this.itemKind = itemKind;
    }

    public Long getSparkPageId() {
        return sparkPageId;
    }

    public void setSparkPageId(Long sparkPageId) {
        this.sparkPageId = sparkPageId;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getTargetUrl() {
        return targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getDeepLink() {
        return deepLink;
    }

    public void setDeepLink(String deepLink) {
        this.deepLink = deepLink;
    }

    public String getTargetInstant() {
        return targetInstant;
    }

    public void setTargetInstant(String targetInstant) {
        this.targetInstant = targetInstant;
    }

    public String getExtId() {
        return extId;
    }

    public void setExtId(String extId) {
        this.extId = extId;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
