package com.omni.ads.model.adsconfig;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(
        ignoreUnknown = true,
        value = {"fail", "ok"}
)
public class HttpResponse<T> {
    private static final int HTTP_SUCC = 0;
    private static final int HTTP_ERROR = 1;
    private static final int HTTP_NOT_AUTH = 403;
    private static final int HTTP_NOT_FOUND = 404;
    private static final int HTTP_UNAUTHORIZED = 401;
    private int code = 0;
    private String msg;
    private T data;

    public HttpResponse() {
    }

    public HttpResponse<T> ok() {
        this.code = 0;
        return this;
    }

    public HttpResponse<T> fail() {
        this.code = 1;
        return this;
    }

    public HttpResponse<T> notAuth() {
        this.code = 403;
        return this;
    }

    public HttpResponse<T> notFound() {
        this.code = 404;
        return this;
    }

    public HttpResponse<T> unauthorized() {
        this.code = 401;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }
}
