package com.omni.ads.model.adscreativity;

import com.omni.ads.model.adscreativity.vo.AdsAdCollectReq;
import com.omni.ads.model.adscreativity.vo.AdsAdDelReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.Valid;
import java.io.Serializable;
import java.util.List;


@ApiModel("批量广告请求对象")
public class AdsAdCollectBatchReq implements Serializable {
    @Valid
    @ApiParam(value = "新增广告列表", required = true)
    private List<AdsAdCollectReq> editList;
    @Valid
    @ApiParam(value = "编辑广告列表", required = true)
    private List<AdsAdCollectReq> addList;
    @ApiParam(value = "删除广告列表", required = true)
    private List<AdsAdDelReq> delList;
    private List<String> keyEditList;
    private List<String> keyAddList;
    private List<String> keyDelList;

    public List<AdsAdCollectReq> getEditList() {
        return editList;
    }

    public void setEditList(List<AdsAdCollectReq> editList) {
        this.editList = editList;
    }

    public List<AdsAdCollectReq> getAddList() {
        return addList;
    }

    public void setAddList(List<AdsAdCollectReq> addList) {
        this.addList = addList;
    }

    public List<AdsAdDelReq> getDelList() {
        return delList;
    }

    public void setDelList(List<AdsAdDelReq> delList) {
        this.delList = delList;
    }
}
