package com.omni.ads.model.adscreativity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.omni.ads.model.adscreativity.vo.AdsAdMaterialVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;


@ApiModel("广告详情对象")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdsAdCollectResp implements Serializable {

    /****************************************
     * ************  基础信息 ***************
     ****************************************/

    @ApiModelProperty(value = "广告ID")
    private Long adId;

    @ApiModelProperty(value = "广告名称")
    private String adName;

    @ApiModelProperty(value = "外部广告id")
    private String openAdId;

    @ApiModelProperty(value = "广告状态(按位或)1:广告启停位(1:表示暂停;0表示启用)2:广告组启停位(1:表示暂停;0表示启用)4:计划启停位(1:表示暂停;0表示启用)8:应用状态位(1:应用导致暂停;0表示正常)16:余额状态位(1:余额导致暂停;0表示正常)32:限额状态位(1:限额导致暂停;0表示正常)")
    private Integer status;

    @ApiModelProperty(value = "前端展示状态")
    private Integer showStatus; //展示状态

    @ApiModelProperty(value = "展示状态描述")
    private String showStatusName; //展示状态名称

    @ApiModelProperty(value = "详细状态描述（子状态）")
    private String subShowStatusName;

    @ApiModelProperty(value = "广告启停状态：1:表示暂停;0表示启用")
    private Integer status2;

    @ApiModelProperty(value = "广告来源，1:oppo")
    private Integer adSource;

    @ApiModelProperty(value = "统一规格id")
    private Integer globalSpecId;

    @ApiModelProperty(value = "删除状态")
    private Integer deleteFlag; //删除状态 0-未删除 1-已删除

    /****************************************
     * ************  计划广告组 **************
     ****************************************/

    @ApiModelProperty(value = "计划ID")
    private Long adPlanId;

    @ApiModelProperty(value = "广告组ID")
    private Long adGroupId;

    @ApiModelProperty(value = "广告版本: 2表示2.0版本广告，3表示3.0版本广告")
    private Integer adFlag;

    /****************************************
     * ************  创意相关 ***************
     ****************************************/

    @ApiModelProperty(value = "广告文案")
    private String copywriter;// 广告文案

    @ApiModelProperty(value = "广告描述", required = false)
    private String content;

    @ApiModelProperty(value = "文案id", required = false)
    private Long copywriterId;

    @ApiModelProperty(value = "品牌名称")
    private String brandName;// 品牌名称

    @ApiModelProperty(value = "按钮文案")
    private String buttonTxt;// 按钮文案

    @ApiModelProperty(value = "图片素材id")
    private List<AdsAdMaterialVo> imgMats;

    @ApiModelProperty(value = "视频素材id")
    private List<AdsAdMaterialVo> videoMats;

    @ApiModelProperty(value = "互动创意id")
    private List<AdsAdMaterialVo> interactMats;

    @ApiModelProperty(value = "品牌LOGO图片id")
    private AdsAdMaterialVo brandLogoImg;

    @ApiModelProperty(value = "视频结束背景图id")
    private AdsAdMaterialVo videoBgImg;

    @ApiModelProperty(value = "视频封面图id")
    private AdsAdMaterialVo videoImg;

    /****************************************
     * ************  监测链接 ***************
     ****************************************/

    @ApiModelProperty(value = "曝光监测链接")
    private String exposeUrl;

    @ApiModelProperty(value = "点击监测链接")
    private String clickUrl;

    @ApiModelProperty(value = "开始播放监测链接")
    private String playBeginUrl;

    @ApiModelProperty(value = "结束播放监测链接")
    private String playEndUrl;

    @ApiModelProperty(value = "下载监测链接")
    private String downloadUrl;

    @ApiModelProperty(value = "是否开启了衍生 0否 1是")
    private Integer dynamicCr;

    @ApiModelProperty(value = "衍生视频指定模板")
    private String deriveTemplate;

    @ApiModelProperty(value = "是否开启了互动创意 0否 1是")
    private Integer interactCr;

    @ApiModelProperty(value = "应用创意id")
    private Long appCreativeId;

    @ApiModelProperty(value = "小程序类型")
    private Integer appletType;

    @ApiModelProperty(value = "互动创意id")
    private Long creativityId;

    @ApiModelProperty(value = "程序化创意类型： 1：自动衍生视频；2：一键继承；5：程序化创意")
    private Integer vrType;

    @ApiModelProperty(value = "广告创意变体类型：1-商店活动创意")
    private Integer variant;

    /****************************************
     * ************  基础信息 ***************
     ****************************************/

    @ApiModelProperty(value = "插入时间(秒级时间戳)")
    private Integer insertTime;
    @ApiModelProperty(value = "更新时间(秒级时间戳)")
    private Integer updateTime;

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getOpenAdId() {
        return openAdId;
    }

    public void setOpenAdId(String openAdId) {
        this.openAdId = openAdId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDeriveTemplate() {
        return deriveTemplate;
    }

    public void setDeriveTemplate(String deriveTemplate) {
        this.deriveTemplate = deriveTemplate;
    }

    public Long getAppCreativeId() {
        return appCreativeId;
    }

    public void setAppCreativeId(Long appCreativeId) {
        this.appCreativeId = appCreativeId;
    }

    public Integer getAppletType() {
        return appletType;
    }

    public void setAppletType(Integer appletType) {
        this.appletType = appletType;
    }

    public Long getCreativityId() {
        return creativityId;
    }

    public void setCreativityId(Long creativityId) {
        this.creativityId = creativityId;
    }

    public Integer getVrType() {
        return vrType;
    }

    public void setVrType(Integer vrType) {
        this.vrType = vrType;
    }

    public Integer getVariant() {
        return variant;
    }

    public void setVariant(Integer variant) {
        this.variant = variant;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(Integer showStatus) {
        this.showStatus = showStatus;
    }

    public String getShowStatusName() {
        return showStatusName;
    }

    public void setShowStatusName(String showStatusName) {
        this.showStatusName = showStatusName;
    }

    public String getSubShowStatusName() {
        return subShowStatusName;
    }

    public void setSubShowStatusName(String subShowStatusName) {
        this.subShowStatusName = subShowStatusName;
    }

    public Integer getStatus2() {
        return status2;
    }

    public void setStatus2(Integer status2) {
        this.status2 = status2;
    }

    public Integer getAdSource() {
        return adSource;
    }

    public void setAdSource(Integer adSource) {
        this.adSource = adSource;
    }

    public Integer getGlobalSpecId() {
        return globalSpecId;
    }

    public void setGlobalSpecId(Integer globalSpecId) {
        this.globalSpecId = globalSpecId;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getAdPlanId() {
        return adPlanId;
    }

    public void setAdPlanId(Long adPlanId) {
        this.adPlanId = adPlanId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public Integer getAdFlag() {
        return adFlag;
    }

    public void setAdFlag(Integer adFlag) {
        this.adFlag = adFlag;
    }

    public String getCopywriter() {
        return copywriter;
    }

    public void setCopywriter(String copywriter) {
        this.copywriter = copywriter;
    }

    public Long getCopywriterId() {
        return copywriterId;
    }

    public void setCopywriterId(Long copywriterId) {
        this.copywriterId = copywriterId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt;
    }

    public List<AdsAdMaterialVo> getImgMats() {
        return imgMats;
    }

    public void setImgMats(List<AdsAdMaterialVo> imgMats) {
        this.imgMats = imgMats;
    }

    public List<AdsAdMaterialVo> getVideoMats() {
        return videoMats;
    }

    public void setVideoMats(List<AdsAdMaterialVo> videoMats) {
        this.videoMats = videoMats;
    }

    public List<AdsAdMaterialVo> getInteractMats() {
        return interactMats;
    }

    public void setInteractMats(List<AdsAdMaterialVo> interactMats) {
        this.interactMats = interactMats;
    }

    public AdsAdMaterialVo getBrandLogoImg() {
        return brandLogoImg;
    }

    public void setBrandLogoImg(AdsAdMaterialVo brandLogoImg) {
        this.brandLogoImg = brandLogoImg;
    }

    public AdsAdMaterialVo getVideoBgImg() {
        return videoBgImg;
    }

    public void setVideoBgImg(AdsAdMaterialVo videoBgImg) {
        this.videoBgImg = videoBgImg;
    }

    public AdsAdMaterialVo getVideoImg() {
        return videoImg;
    }

    public void setVideoImg(AdsAdMaterialVo videoImg) {
        this.videoImg = videoImg;
    }

    public String getExposeUrl() {
        return exposeUrl;
    }

    public void setExposeUrl(String exposeUrl) {
        this.exposeUrl = exposeUrl;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public String getPlayBeginUrl() {
        return playBeginUrl;
    }

    public void setPlayBeginUrl(String playBeginUrl) {
        this.playBeginUrl = playBeginUrl;
    }

    public String getPlayEndUrl() {
        return playEndUrl;
    }

    public void setPlayEndUrl(String playEndUrl) {
        this.playEndUrl = playEndUrl;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Integer getDynamicCr() {
        return dynamicCr;
    }

    public void setDynamicCr(Integer dynamicCr) {
        this.dynamicCr = dynamicCr;
    }

    public Integer getInteractCr() {
        return interactCr;
    }

    public void setInteractCr(Integer interactCr) {
        this.interactCr = interactCr;
    }

    public Integer getInsertTime() {
        return insertTime;
    }

    public void setInsertTime(Integer insertTime) {
        this.insertTime = insertTime;
    }

    public Integer getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Integer updateTime) {
        this.updateTime = updateTime;
    }
}
