package com.omni.ads.model.adscreativity;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 推广列表数据对象
 * @author Eden
 * @since 2021/1/8
 */

@ApiModel("推广列表数据对象")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdsAdDataResp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "详细状态")
    private Integer status; //详细状态
    @ApiModelProperty(value = "详细状态描述")
    private String statusName; //详细状态名称
    @ApiModelProperty(value = "详细状态描述")
    private String subShowStatusName; //详细状态名称，和statusName一致
    @ApiModelProperty(value = "前端展示状态")
    private Integer showStatus; //展示状态
    @ApiModelProperty(value = "前端展示状态描述")
    private String showStatusName; //展示状态名称
    @ApiModelProperty(value = "投放开关")
    private Integer status2; // 投放开关 0-开启 1-关闭
    @ApiModelProperty(value = "删除状态")
    private Integer deleteFlag; //删除状态 0-未删除 1-已删除

    @ApiModelProperty(value = "是否允许编辑")
    private boolean allowEdit = true;

    @ApiModelProperty(value = "广告计划ID")
    private Long planId; //广告计划ID
    @ApiModelProperty(value = "广告计划名称")
    private String planName; //广告计划名称
    @ApiModelProperty(value = "推广目标")
    private Integer extensionType; //推广目标
    @ApiModelProperty(value = "推广目标名称")
    private String extensionTypeName; //推广目标名称
    @ApiModelProperty(value = "计划日预算")
    private String dayBudget; //计划日预算，分为单位
    @ApiModelProperty(value = "计费类型")
    private Integer billingType; //计费类型，2-cpc 5-ocpx
    @ApiModelProperty(value = "匀速投放类型")
    private Integer pacingStatus;
    @ApiModelProperty(value = "竞价策略")
    private Integer deliveryMode;
    @ApiModelProperty(value = "竞价策略名称")
    private String deliveryModeName;
    /**
     * 在v3/plan/get接口里面叫dayLimit，这里改成budgetLimit是因为group层级也有一个dayLimit重名了。
     */
    @ApiModelProperty("是否限制日预算 0 不限制 1 限制")
    private Integer budgetLimit;
    @ApiModelProperty(value = "计划次日预算")
    private String tomorrowBudget; //计划次日预算，分为单位
    @ApiModelProperty("是否限制次日预算 0 不限制 1 限制")
    private Integer tomorrowLimit;

    @ApiModelProperty(value = "广告组ID")
    private Long adGroupId; //广告组ID
    @ApiModelProperty(value = "广告组名称")
    private String adGroupName; //广告组名称
    @ApiModelProperty(value = "推广流量")
    private Integer extensionFlow; //推广流量
    @ApiModelProperty(value = "推广流量名称")
    private String extensionFlowName; //推广流量名称
    @ApiModelProperty(value = "流量场景")
    private Integer flowScene; //流量场景
    @ApiModelProperty(value = "流量场景名称")
    private String flowSceneName; //流量场景名称
    @ApiModelProperty(value = "基础出价")
    private String price; //基础出价，元为单位
    @ApiModelProperty(value = "转化出价")
    private String ocpcPrice; //转化出价，元为单位
    @ApiModelProperty(value = "转化类型")
    private Integer ocpcType; //转化类型
    @ApiModelProperty(value = "转化类型名称")
    private String ocpcTypeName; //转化类型名称
    @ApiModelProperty(value = "深度转化出价")
    private String deepOcpcPrice; //深度转化出价，元为单位
    @ApiModelProperty(value = "深度转化类型")
    private Integer deepOcpcType; //深度转化类型
    @ApiModelProperty(value = "深度转化类型名称")
    private String deepOcpcTypeName; //深度转化类型名称
    @ApiModelProperty(value = "直达链接")
    private String deepUrl;
    @ApiModelProperty(value = "ocpc转化阶段 1-点击阶段, 2-转化阶段, 3-深度转化阶段")
    private String ocpcState; //转化阶段
    @ApiModelProperty(value = "目标ROI系数")
    private String targetROI; //目标ROI系数
    @ApiModelProperty(value = "动态出价")
    private Integer dynamicPrice; //动态出价
    @ApiModelProperty(value = "应用ID")
    private Long appId;// 应用ID
    @ApiModelProperty(value = "快应用Id")
    private Integer instantAppId;// 快应用Id

    @ApiModelProperty(value = "一键起量状态，0表示未起量，1表示起量中，2表示起量结束")
    private Integer gainQuantityStatus;

    @ApiModelProperty(value = "一键起量状态名称，0表示未起量，1表示起量中，2表示起量结束")
    private String gainQuantityStatusName;

    @ApiModelProperty(value = "一键起量预算，单位是分")
    private Integer gainQuantityBudget;

    @ApiModelProperty(value = "一键起量次数，针对每个广告组，每次起量后累加")
    private Integer gainQuantityCycles;

    @ApiModelProperty(value = "一键起量日期，当且仅当等于当日才能起量")
    private Integer gainQuantityDate;

    @ApiModelProperty(value = "一键起量开关，0表示未开启，1表示开启")
    private Integer gainQuantitySwitch;

    @ApiModelProperty(value = "OCPX自动赔付状态")
    private Integer ocpxCompensateStatus;

    @ApiModelProperty(value = "OCPX自动赔付状态描述")
    private String ocpxCompensateStatusName;

    @ApiModelProperty(value = "OCPX自动赔付金额(分)")
    private String ocpxCompensateAmount;

    @ApiModelProperty(value = "OCPX自动赔付失效原因")
    private String ocpxCompensateMsg;

    @ApiModelProperty(value = "小程序类型")
    private Integer appletType;

    @ApiModelProperty(value = "小程序ID")
    private String appletId;

    @ApiModelProperty(value = "小程序Path")
    private String appletPath;

    @ApiModelProperty(value = "广告类型")
    private Integer advertiseType;

    @ApiModelProperty(value = "广告类型名称")
    private String advertiseTypeName;

    @ApiModelProperty(value = "广告ID")
    private Long adId; //广告ID
    @ApiModelProperty(value = "广告名称")
    private String adName; //广告名称
    @ApiModelProperty(value = "审核状态")
    private Integer auditStatus; //审核状态
    @ApiModelProperty(value = "审核原因")
    private String auditDesc; //审核原因
    @ApiModelProperty(value = "创意类型")
    private String creativeTypeName; //创意类型
    @ApiModelProperty(value = "创意规格")
    private Integer globalSpecId; //创意规格
    @ApiModelProperty(value = "创意规格名称")
    private String globalSpecName; //创意规格名称
    @ApiModelProperty(value = "低效广告标识")
    private Integer ineffectiveAdFlag; //低效广告标识
    @ApiModelProperty(value = "低效广告标识提示语")
    private String ineffectiveAdHint; //低效广告标识提示语

    @ApiModelProperty(value = "程序化类型【0-非程序化(默认),5-程序化創意】")
    @Deprecated
    private Integer programmaticType;
    @ApiModelProperty(value = "程序化类型展示名称【0-非程序化(默认),5-程序化創意】")
    @Deprecated
    private String programmaticTypeName;

    @ApiModelProperty(value = "创意类型 0 默认，1 自动衍生视频，2 一键继承，5 程序化创意，6 动态创意", hidden = true)
    private Integer vrType;
    @ApiModelProperty(value = "创意类型名称 0 默认，1 自动衍生视频，2 一键继承，5 程序化创意，6 动态创意", hidden = true)
    private String vrTypeName;
    @ApiModelProperty(value = "广告创意变体类型：1-商店活动创意")
    private Integer variant;
    @ApiModelProperty(value = "记录插入时间(秒级时间戳)")
    private Integer insertTime;
    @ApiModelProperty(value = "记录更新时间(秒级时间戳)")
    private Integer updateTime;

    @ApiModelProperty(value = "push应用内页类型")
    private Integer pushAppPageType;

    @ApiModelProperty(value = "消耗金额")
    private String cost; //消耗金额，元为单位
    @ApiModelProperty(value = "曝光量")
    private String expose; //曝光量
    @ApiModelProperty(value = "点击量")
    private String click; //点击量
    @ApiModelProperty(value = "点击成本")
    private String clickPrice; //点击成本
    @ApiModelProperty(value = "点击率")
    private String clickRate; //点击率
    @ApiModelProperty(value = "下载量")
    private String download; //下载量
    @ApiModelProperty(value = "下载成本")
    private String downloadPrice; //下载成本
    @ApiModelProperty(value = "下载率")
    private String downloadRate; //下载率
    @ApiModelProperty(value = "ecpm")
    private String ecpm; //ecpm，元为单位
    @ApiModelProperty(value = "表单提交量")
    private String formCnt; //表单提交量
    @ApiModelProperty(value = "表单提交成本")
    private String formCntPrice; //表单提交成本，元为单位
    @ApiModelProperty(value = "表单转化率")
    private String formPriceRate; //表单转化率
    @ApiModelProperty(value = "回传激活量")
    private String convertActive; //回传激活量
    @ApiModelProperty(value = "回传激活成本")
    private String convertActivePrice; //回传激活成本，元为单位
    @ApiModelProperty(value = "注册量")
    private String convertRegister; //注册量
    @ApiModelProperty(value = "注册成本")
    private String convertRegisterPrice; //注册成本，元为单位
    @ApiModelProperty(value = "回传留存")
    private String convertRetention; //回传留存
    @ApiModelProperty(value = "回传留存成本")
    private String convertRetentionPrice; //回传留存成本，元为单位
    @ApiModelProperty(value = "应用内授信")
    private String convertAppCredit; //应用内授信
    @ApiModelProperty(value = "应用内授信成本")
    private String convertAppCreditPrice; //应用内授信成本，元为单位
    @ApiModelProperty(value = "应用内下单（电商）")
    private String convertAppOrder; //应用内下单
    @ApiModelProperty(value = "应用内下单（电商）成本")
    private String convertAppOrderPrice; //应用内下单成本，元为单位
    @ApiModelProperty(value = "应用内付费")
    private String convertAppPay; //应用内付费
    @ApiModelProperty(value = "应用内付费成本")
    private String convertAppPayPrice; //应用内付费成本，元为单位
    @ApiModelProperty(value = "应用内自定义转化")
    private String convertAppCustom; //应用内自定义转化
    @ApiModelProperty(value = "应用内自定义转化成本")
    private String convertAppCustomPrice; //应用内自定义转化成本，元为单位
    @ApiModelProperty(value = "回传拉活")
    private String convertDp; //回传拉活
    @ApiModelProperty(value = "回传拉活成本")
    private String convertDpPrice; //回传拉活成本，元为单位
    @ApiModelProperty(value = "deeplink回传拉活转化率")
    private String convertDpRate;
    @ApiModelProperty(value = "deeplink回传激活量")
    private String dpConvertActivationNums; //deeplink回传激活量
    @ApiModelProperty(value = "deeplink回传激活成本")
    private String dpConvertActivationPrice; //deeplink回传激活成本
    @ApiModelProperty(value = "deeplink回传注册量")
    private String dpConvertRegisterNums; //deeplink回传注册量
    @ApiModelProperty(value = "deeplink回传注册成本")
    private String dpConvertRegisterPrice; //deeplink回传注册成本
    @ApiModelProperty(value = "deeplink应用付费量")
    private String dpAppPayNums; //deeplink应用付费量
    @ApiModelProperty(value = "deeplink应用付费成本")
    private String dpAppPayPrice; //deeplink应用付费成本
    @ApiModelProperty(value = "deeplink自定义转化量")
    private String dpUdConvertNums; //deeplink自定义转化量
    @ApiModelProperty(value = "deeplink自定义转化成本")
    private String dpUdConvertPrice; //deeplink自定义转化成本
    @ApiModelProperty(value = "deeplink应用内授信量")
    private String dpAppCreditNums; //deeplink应用内授信量
    @ApiModelProperty(value = "deeplink应用内授信成本")
    private String dpAppCreditPrice; //deeplink应用内授信成本
    @ApiModelProperty(value = "deeplink应用内下单量")
    private String dpAppOrderNums; //deeplink应用内下单量
    @ApiModelProperty(value = "deeplink应用内下单成本")
    private String dpAppOrderPrice; //deeplink应用内下单成本
    @ApiModelProperty(value = "deeplink应用内下单转化率")
    private String dpAppOrderRate;
    @ApiModelProperty(value = "快应用付费")
    private String quickAppPay; //快应用付费
    @ApiModelProperty(value = "快应用付费成本")
    private String quickAppPayPrice; //快应用付费成本
    @ApiModelProperty(value = "投放模式")
    private String adServingType; // 0-普通投放 1-跟随投放
    @ApiModelProperty(value = "更随最高价格")
    private String followMaxPrice;
    @ApiModelProperty(value = "跟随appId列表")
    private List<Long> followAppIdList;
    @ApiModelProperty(value = "是否免一阶")
    private Integer defaultSecondStage;
    @ApiModelProperty(value = "deeplink回传存留量")
    private String dpConvertRetentionNums; //deeplink回传存留量
    @ApiModelProperty(value = "deeplink回传存留成本")
    private String dpConvertRetentionPrice; //deeplink回传存留成本
    @ApiModelProperty(value = "快应用加桌量")
    private String qappQuickLnkNums; //快应用加桌量
    @ApiModelProperty(value = "快应用加桌成本")
    private String qappQuickLnkPrice; //快应用加桌成本
    @ApiModelProperty(value = "分成后快应用变现LTV1")
    private String qappLtv1; //分成后快应用变现LTV1
    @ApiModelProperty(value = "分成后快应用变现ROI1")
    private String qappRoi1; //分成后快应用变现ROI1
    @ApiModelProperty(value = "快应用关键行为量")
    private String quickAppActNum; //快应用关键行为量
    @ApiModelProperty(value = "快应用关键行为成本")
    private String quickAppActCost; //快应用关键行为成本
    @ApiModelProperty(value = "回传次留率")
    private String convertRetentionRate; //回传次留率
    @ApiModelProperty(value = "表单关键行为量")
    private String formKeyActNums; //表单关键行为量
    @ApiModelProperty(value = "表单关键行为成本")
    private String formKeyActPrice; //表单关键行为成本
    @ApiModelProperty(value = "有效咨询量")
    private String effectConsultNums; //有效咨询量
    @ApiModelProperty(value = "有效咨询成本")
    private String effectConsultPrice; //有效咨询成本
    @ApiModelProperty(value = "微信关注量")
    private String wechatFocusNums; //微信关注量
    @ApiModelProperty(value = "微信关注成本")
    private String wechatFocusPrice; //微信关注成本
    @ApiModelProperty(value = "网页购买量")
    private String webPageBuyNums; //网页购买量
    @ApiModelProperty(value = "网页购买成本")
    private String webPageBuyPrice; //网页购买成本
    @ApiModelProperty(value = "拨打电话量")
    private String callUpNums; //拨打电话量
    @ApiModelProperty(value = "拨打电话成本")
    private String callUpPrice; //拨打电话成本
    @ApiModelProperty(value = "游戏关键行为量")
    private String gameAppActNums; //游戏关键行为量
    @ApiModelProperty(value = "游戏关键行为成本")
    private String gameAppActPrice; //游戏关键行为成本
    @ApiModelProperty(value = "（DP拉活）回传留存率")
    private String dpConvertRetentionRate; //（DP拉活）回传留存率
    @ApiModelProperty(value = "微信小游戏注册量")
    private String wechatGameRegister;
    @ApiModelProperty(value = "微信小游戏注册成本")
    private String wechatGameRegisterPrice;
    @ApiModelProperty(value = "微信小游戏付费量")
    private String wechatGamePay;
    @ApiModelProperty(value = "微信小游戏付费成本")
    private String wechatGamePayPrice;
    @ApiModelProperty(value = "付费次数")
    private String payNums;
    @ApiModelProperty(value = "每次付费成本")
    private String payPerPrice;
    @ApiModelProperty(value = "第3日留存")
    private String convertRetention3;
    @ApiModelProperty(value = "第4日留存")
    private String convertRetention4;
    @ApiModelProperty(value = "第5日留存")
    private String convertRetention5;
    @ApiModelProperty(value = "第6日留存")
    private String convertRetention6;
    @ApiModelProperty(value = "第7日留存")
    private String convertRetention7;
    @ApiModelProperty(value = "微信小游戏付费总额")
    private String wechatGamePayCost;
    @ApiModelProperty(value = "微信小游戏首次付费人数")
    private String firstPayNum;
    @ApiModelProperty(value = "微信小游戏ROI1")
    private String wechatGameRoi1;
    @ApiModelProperty(value = "第3日留存率")
    private String convertRetention3Rate;
    @ApiModelProperty(value = "第4日留存率")
    private String convertRetention4Rate;
    @ApiModelProperty(value = "第5日留存率")
    private String convertRetention5Rate;
    @ApiModelProperty(value = "第6日留存率")
    private String convertRetention6Rate;
    @ApiModelProperty(value = "第7日留存率")
    private String convertRetention7Rate;
    @ApiModelProperty(value = "LT7总留存")
    private String lt7;
    @ApiModelProperty(value = "LI7总留存率")
    private String lt7Rate;
    @ApiModelProperty(value = "注册-应用付费率")
    private String registerAppPayRate;
    @ApiModelProperty(value = "预约量")
    private String bookNums;
    @ApiModelProperty(value = "取消预约量")
    private String cancelBookNums;
    @ApiModelProperty(value = "预约下载量")
    private String bookDownloadNums;
    @ApiModelProperty(value = "长留自定义转化量")
    private String convertLongRetentionNums;
    @ApiModelProperty(value = "长留自定义转化成本")
    private String convertLongRetentionPrice;
    @ApiModelProperty(value = "每次付费转化量")
    private String convertPerPayNums;
    @ApiModelProperty(value = "每次付费成本")
    private String convertPerPayPrice;
    @ApiModelProperty(value = "roi14")
    private String roi14;
    @ApiModelProperty(value = "ltv14")
    private String ltv14;
    @ApiModelProperty(value = "行业一级分类")
    private String cateName;
    @ApiModelProperty(value = "行业二级分类")
    private String subCateName;
    @ApiModelProperty(value = "行业三级分类")
    private String thirdCateName;
    @ApiModelProperty(value = "快应用关键行为转化率")
    private String quickAppActRate;
    @ApiModelProperty(value = "付费金额")
    private String convertPayCost; //付费金额
    @ApiModelProperty(value = "应用ROI")
    private String appRoi;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public String getSubShowStatusName() {
        return subShowStatusName;
    }

    public void setSubShowStatusName(String subShowStatusName) {
        this.subShowStatusName = subShowStatusName;
    }

    public Integer getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(Integer showStatus) {
        this.showStatus = showStatus;
    }

    public String getShowStatusName() {
        return showStatusName;
    }

    public void setShowStatusName(String showStatusName) {
        this.showStatusName = showStatusName;
    }

    public Integer getStatus2() {
        return status2;
    }

    public void setStatus2(Integer status2) {
        this.status2 = status2;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public boolean isAllowEdit() {
        return allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public String getExtensionTypeName() {
        return extensionTypeName;
    }

    public void setExtensionTypeName(String extensionTypeName) {
        this.extensionTypeName = extensionTypeName;
    }

    public String getDayBudget() {
        return dayBudget;
    }

    public void setDayBudget(String dayBudget) {
        this.dayBudget = dayBudget;
    }

    public Integer getBillingType() {
        return billingType;
    }

    public void setBillingType(Integer billingType) {
        this.billingType = billingType;
    }

    public Integer getPacingStatus() {
        return pacingStatus;
    }

    public void setPacingStatus(Integer pacingStatus) {
        this.pacingStatus = pacingStatus;
    }

    public Integer getDeliveryMode() {
        return deliveryMode;
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getDeliveryModeName() {
        return deliveryModeName;
    }

    public void setDeliveryModeName(String deliveryModeName) {
        this.deliveryModeName = deliveryModeName;
    }

    public Integer getBudgetLimit() {
        return budgetLimit;
    }

    public void setBudgetLimit(Integer budgetLimit) {
        this.budgetLimit = budgetLimit;
    }

    public String getTomorrowBudget() {
        return tomorrowBudget;
    }

    public void setTomorrowBudget(String tomorrowBudget) {
        this.tomorrowBudget = tomorrowBudget;
    }

    public Integer getTomorrowLimit() {
        return tomorrowLimit;
    }

    public void setTomorrowLimit(Integer tomorrowLimit) {
        this.tomorrowLimit = tomorrowLimit;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public Integer getExtensionFlow() {
        return extensionFlow;
    }

    public void setExtensionFlow(Integer extensionFlow) {
        this.extensionFlow = extensionFlow;
    }

    public String getExtensionFlowName() {
        return extensionFlowName;
    }

    public void setExtensionFlowName(String extensionFlowName) {
        this.extensionFlowName = extensionFlowName;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }

    public String getFlowSceneName() {
        return flowSceneName;
    }

    public void setFlowSceneName(String flowSceneName) {
        this.flowSceneName = flowSceneName;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getOcpcPrice() {
        return ocpcPrice;
    }

    public void setOcpcPrice(String ocpcPrice) {
        this.ocpcPrice = ocpcPrice;
    }

    public Integer getOcpcType() {
        return ocpcType;
    }

    public void setOcpcType(Integer ocpcType) {
        this.ocpcType = ocpcType;
    }

    public String getOcpcTypeName() {
        return ocpcTypeName;
    }

    public void setOcpcTypeName(String ocpcTypeName) {
        this.ocpcTypeName = ocpcTypeName;
    }

    public String getDeepOcpcPrice() {
        return deepOcpcPrice;
    }

    public void setDeepOcpcPrice(String deepOcpcPrice) {
        this.deepOcpcPrice = deepOcpcPrice;
    }

    public Integer getDeepOcpcType() {
        return deepOcpcType;
    }

    public void setDeepOcpcType(Integer deepOcpcType) {
        this.deepOcpcType = deepOcpcType;
    }

    public String getDeepOcpcTypeName() {
        return deepOcpcTypeName;
    }

    public void setDeepOcpcTypeName(String deepOcpcTypeName) {
        this.deepOcpcTypeName = deepOcpcTypeName;
    }

    public String getDeepUrl() {
        return deepUrl;
    }

    public void setDeepUrl(String deepUrl) {
        this.deepUrl = deepUrl;
    }

    public String getOcpcState() {
        return ocpcState;
    }

    public void setOcpcState(String ocpcState) {
        this.ocpcState = ocpcState;
    }

    public String getTargetROI() {
        return targetROI;
    }

    public void setTargetROI(String targetROI) {
        this.targetROI = targetROI;
    }

    public Integer getDynamicPrice() {
        return dynamicPrice;
    }

    public void setDynamicPrice(Integer dynamicPrice) {
        this.dynamicPrice = dynamicPrice;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getInstantAppId() {
        return instantAppId;
    }

    public void setInstantAppId(Integer instantAppId) {
        this.instantAppId = instantAppId;
    }

    public Integer getGainQuantityStatus() {
        return gainQuantityStatus;
    }

    public void setGainQuantityStatus(Integer gainQuantityStatus) {
        this.gainQuantityStatus = gainQuantityStatus;
    }

    public String getGainQuantityStatusName() {
        return gainQuantityStatusName;
    }

    public void setGainQuantityStatusName(String gainQuantityStatusName) {
        this.gainQuantityStatusName = gainQuantityStatusName;
    }

    public Integer getGainQuantityBudget() {
        return gainQuantityBudget;
    }

    public void setGainQuantityBudget(Integer gainQuantityBudget) {
        this.gainQuantityBudget = gainQuantityBudget;
    }

    public Integer getGainQuantityCycles() {
        return gainQuantityCycles;
    }

    public void setGainQuantityCycles(Integer gainQuantityCycles) {
        this.gainQuantityCycles = gainQuantityCycles;
    }

    public Integer getGainQuantityDate() {
        return gainQuantityDate;
    }

    public void setGainQuantityDate(Integer gainQuantityDate) {
        this.gainQuantityDate = gainQuantityDate;
    }

    public Integer getGainQuantitySwitch() {
        return gainQuantitySwitch;
    }

    public void setGainQuantitySwitch(Integer gainQuantitySwitch) {
        this.gainQuantitySwitch = gainQuantitySwitch;
    }

    public Integer getOcpxCompensateStatus() {
        return ocpxCompensateStatus;
    }

    public void setOcpxCompensateStatus(Integer ocpxCompensateStatus) {
        this.ocpxCompensateStatus = ocpxCompensateStatus;
    }

    public String getOcpxCompensateStatusName() {
        return ocpxCompensateStatusName;
    }

    public void setOcpxCompensateStatusName(String ocpxCompensateStatusName) {
        this.ocpxCompensateStatusName = ocpxCompensateStatusName;
    }

    public String getOcpxCompensateAmount() {
        return ocpxCompensateAmount;
    }

    public void setOcpxCompensateAmount(String ocpxCompensateAmount) {
        this.ocpxCompensateAmount = ocpxCompensateAmount;
    }

    public String getOcpxCompensateMsg() {
        return ocpxCompensateMsg;
    }

    public void setOcpxCompensateMsg(String ocpxCompensateMsg) {
        this.ocpxCompensateMsg = ocpxCompensateMsg;
    }

    public Integer getAppletType() {
        return appletType;
    }

    public void setAppletType(Integer appletType) {
        this.appletType = appletType;
    }

    public String getAppletId() {
        return appletId;
    }

    public void setAppletId(String appletId) {
        this.appletId = appletId;
    }

    public String getAppletPath() {
        return appletPath;
    }

    public void setAppletPath(String appletPath) {
        this.appletPath = appletPath;
    }

    public Integer getAdvertiseType() {
        return advertiseType;
    }

    public void setAdvertiseType(Integer advertiseType) {
        this.advertiseType = advertiseType;
    }

    public String getAdvertiseTypeName() {
        return advertiseTypeName;
    }

    public void setAdvertiseTypeName(String advertiseTypeName) {
        this.advertiseTypeName = advertiseTypeName;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public String getCreativeTypeName() {
        return creativeTypeName;
    }

    public void setCreativeTypeName(String creativeTypeName) {
        this.creativeTypeName = creativeTypeName;
    }

    public Integer getGlobalSpecId() {
        return globalSpecId;
    }

    public void setGlobalSpecId(Integer globalSpecId) {
        this.globalSpecId = globalSpecId;
    }

    public String getGlobalSpecName() {
        return globalSpecName;
    }

    public void setGlobalSpecName(String globalSpecName) {
        this.globalSpecName = globalSpecName;
    }

    public Integer getIneffectiveAdFlag() {
        return ineffectiveAdFlag;
    }

    public void setIneffectiveAdFlag(Integer ineffectiveAdFlag) {
        this.ineffectiveAdFlag = ineffectiveAdFlag;
    }

    public String getIneffectiveAdHint() {
        return ineffectiveAdHint;
    }

    public void setIneffectiveAdHint(String ineffectiveAdHint) {
        this.ineffectiveAdHint = ineffectiveAdHint;
    }

    public Integer getProgrammaticType() {
        return programmaticType;
    }

    public void setProgrammaticType(Integer programmaticType) {
        this.programmaticType = programmaticType;
    }

    public String getProgrammaticTypeName() {
        return programmaticTypeName;
    }

    public void setProgrammaticTypeName(String programmaticTypeName) {
        this.programmaticTypeName = programmaticTypeName;
    }

    public Integer getVrType() {
        return vrType;
    }

    public void setVrType(Integer vrType) {
        this.vrType = vrType;
    }

    public String getVrTypeName() {
        return vrTypeName;
    }

    public void setVrTypeName(String vrTypeName) {
        this.vrTypeName = vrTypeName;
    }

    public Integer getVariant() {
        return variant;
    }

    public void setVariant(Integer variant) {
        this.variant = variant;
    }

    public Integer getInsertTime() {
        return insertTime;
    }

    public void setInsertTime(Integer insertTime) {
        this.insertTime = insertTime;
    }

    public Integer getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Integer updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getPushAppPageType() {
        return pushAppPageType;
    }

    public void setPushAppPageType(Integer pushAppPageType) {
        this.pushAppPageType = pushAppPageType;
    }

    public String getCost() {
        return cost;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }

    public String getExpose() {
        return expose;
    }

    public void setExpose(String expose) {
        this.expose = expose;
    }

    public String getClick() {
        return click;
    }

    public void setClick(String click) {
        this.click = click;
    }

    public String getClickPrice() {
        return clickPrice;
    }

    public void setClickPrice(String clickPrice) {
        this.clickPrice = clickPrice;
    }

    public String getClickRate() {
        return clickRate;
    }

    public void setClickRate(String clickRate) {
        this.clickRate = clickRate;
    }

    public String getDownload() {
        return download;
    }

    public void setDownload(String download) {
        this.download = download;
    }

    public String getDownloadPrice() {
        return downloadPrice;
    }

    public void setDownloadPrice(String downloadPrice) {
        this.downloadPrice = downloadPrice;
    }

    public String getDownloadRate() {
        return downloadRate;
    }

    public void setDownloadRate(String downloadRate) {
        this.downloadRate = downloadRate;
    }

    public String getEcpm() {
        return ecpm;
    }

    public void setEcpm(String ecpm) {
        this.ecpm = ecpm;
    }

    public String getFormCnt() {
        return formCnt;
    }

    public void setFormCnt(String formCnt) {
        this.formCnt = formCnt;
    }

    public String getFormCntPrice() {
        return formCntPrice;
    }

    public void setFormCntPrice(String formCntPrice) {
        this.formCntPrice = formCntPrice;
    }

    public String getFormPriceRate() {
        return formPriceRate;
    }

    public void setFormPriceRate(String formPriceRate) {
        this.formPriceRate = formPriceRate;
    }

    public String getConvertActive() {
        return convertActive;
    }

    public void setConvertActive(String convertActive) {
        this.convertActive = convertActive;
    }

    public String getConvertActivePrice() {
        return convertActivePrice;
    }

    public void setConvertActivePrice(String convertActivePrice) {
        this.convertActivePrice = convertActivePrice;
    }

    public String getConvertRegister() {
        return convertRegister;
    }

    public void setConvertRegister(String convertRegister) {
        this.convertRegister = convertRegister;
    }

    public String getConvertRegisterPrice() {
        return convertRegisterPrice;
    }

    public void setConvertRegisterPrice(String convertRegisterPrice) {
        this.convertRegisterPrice = convertRegisterPrice;
    }

    public String getConvertRetention() {
        return convertRetention;
    }

    public void setConvertRetention(String convertRetention) {
        this.convertRetention = convertRetention;
    }

    public String getConvertRetentionPrice() {
        return convertRetentionPrice;
    }

    public void setConvertRetentionPrice(String convertRetentionPrice) {
        this.convertRetentionPrice = convertRetentionPrice;
    }

    public String getConvertAppCredit() {
        return convertAppCredit;
    }

    public void setConvertAppCredit(String convertAppCredit) {
        this.convertAppCredit = convertAppCredit;
    }

    public String getConvertAppCreditPrice() {
        return convertAppCreditPrice;
    }

    public void setConvertAppCreditPrice(String convertAppCreditPrice) {
        this.convertAppCreditPrice = convertAppCreditPrice;
    }

    public String getConvertAppOrder() {
        return convertAppOrder;
    }

    public void setConvertAppOrder(String convertAppOrder) {
        this.convertAppOrder = convertAppOrder;
    }

    public String getConvertAppOrderPrice() {
        return convertAppOrderPrice;
    }

    public void setConvertAppOrderPrice(String convertAppOrderPrice) {
        this.convertAppOrderPrice = convertAppOrderPrice;
    }

    public String getConvertAppPay() {
        return convertAppPay;
    }

    public void setConvertAppPay(String convertAppPay) {
        this.convertAppPay = convertAppPay;
    }

    public String getConvertAppPayPrice() {
        return convertAppPayPrice;
    }

    public void setConvertAppPayPrice(String convertAppPayPrice) {
        this.convertAppPayPrice = convertAppPayPrice;
    }

    public String getConvertAppCustom() {
        return convertAppCustom;
    }

    public void setConvertAppCustom(String convertAppCustom) {
        this.convertAppCustom = convertAppCustom;
    }

    public String getConvertAppCustomPrice() {
        return convertAppCustomPrice;
    }

    public void setConvertAppCustomPrice(String convertAppCustomPrice) {
        this.convertAppCustomPrice = convertAppCustomPrice;
    }

    public String getConvertDp() {
        return convertDp;
    }

    public void setConvertDp(String convertDp) {
        this.convertDp = convertDp;
    }

    public String getConvertDpPrice() {
        return convertDpPrice;
    }

    public void setConvertDpPrice(String convertDpPrice) {
        this.convertDpPrice = convertDpPrice;
    }

    public String getConvertDpRate() {
        return convertDpRate;
    }

    public void setConvertDpRate(String convertDpRate) {
        this.convertDpRate = convertDpRate;
    }

    public String getDpConvertActivationNums() {
        return dpConvertActivationNums;
    }

    public void setDpConvertActivationNums(String dpConvertActivationNums) {
        this.dpConvertActivationNums = dpConvertActivationNums;
    }

    public String getDpConvertActivationPrice() {
        return dpConvertActivationPrice;
    }

    public void setDpConvertActivationPrice(String dpConvertActivationPrice) {
        this.dpConvertActivationPrice = dpConvertActivationPrice;
    }

    public String getDpConvertRegisterNums() {
        return dpConvertRegisterNums;
    }

    public void setDpConvertRegisterNums(String dpConvertRegisterNums) {
        this.dpConvertRegisterNums = dpConvertRegisterNums;
    }

    public String getDpConvertRegisterPrice() {
        return dpConvertRegisterPrice;
    }

    public void setDpConvertRegisterPrice(String dpConvertRegisterPrice) {
        this.dpConvertRegisterPrice = dpConvertRegisterPrice;
    }

    public String getDpAppPayNums() {
        return dpAppPayNums;
    }

    public void setDpAppPayNums(String dpAppPayNums) {
        this.dpAppPayNums = dpAppPayNums;
    }

    public String getDpAppPayPrice() {
        return dpAppPayPrice;
    }

    public void setDpAppPayPrice(String dpAppPayPrice) {
        this.dpAppPayPrice = dpAppPayPrice;
    }

    public String getDpUdConvertNums() {
        return dpUdConvertNums;
    }

    public void setDpUdConvertNums(String dpUdConvertNums) {
        this.dpUdConvertNums = dpUdConvertNums;
    }

    public String getDpUdConvertPrice() {
        return dpUdConvertPrice;
    }

    public void setDpUdConvertPrice(String dpUdConvertPrice) {
        this.dpUdConvertPrice = dpUdConvertPrice;
    }

    public String getDpAppCreditNums() {
        return dpAppCreditNums;
    }

    public void setDpAppCreditNums(String dpAppCreditNums) {
        this.dpAppCreditNums = dpAppCreditNums;
    }

    public String getDpAppCreditPrice() {
        return dpAppCreditPrice;
    }

    public void setDpAppCreditPrice(String dpAppCreditPrice) {
        this.dpAppCreditPrice = dpAppCreditPrice;
    }

    public String getDpAppOrderNums() {
        return dpAppOrderNums;
    }

    public void setDpAppOrderNums(String dpAppOrderNums) {
        this.dpAppOrderNums = dpAppOrderNums;
    }

    public String getDpAppOrderPrice() {
        return dpAppOrderPrice;
    }

    public void setDpAppOrderPrice(String dpAppOrderPrice) {
        this.dpAppOrderPrice = dpAppOrderPrice;
    }

    public String getDpAppOrderRate() {
        return dpAppOrderRate;
    }

    public void setDpAppOrderRate(String dpAppOrderRate) {
        this.dpAppOrderRate = dpAppOrderRate;
    }

    public String getQuickAppPay() {
        return quickAppPay;
    }

    public void setQuickAppPay(String quickAppPay) {
        this.quickAppPay = quickAppPay;
    }

    public String getQuickAppPayPrice() {
        return quickAppPayPrice;
    }

    public void setQuickAppPayPrice(String quickAppPayPrice) {
        this.quickAppPayPrice = quickAppPayPrice;
    }

    public String getAdServingType() {
        return adServingType;
    }

    public void setAdServingType(String adServingType) {
        this.adServingType = adServingType;
    }

    public String getFollowMaxPrice() {
        return followMaxPrice;
    }

    public void setFollowMaxPrice(String followMaxPrice) {
        this.followMaxPrice = followMaxPrice;
    }

    public List<Long> getFollowAppIdList() {
        return followAppIdList;
    }

    public void setFollowAppIdList(List<Long> followAppIdList) {
        this.followAppIdList = followAppIdList;
    }

    public Integer getDefaultSecondStage() {
        return defaultSecondStage;
    }

    public void setDefaultSecondStage(Integer defaultSecondStage) {
        this.defaultSecondStage = defaultSecondStage;
    }

    public String getDpConvertRetentionNums() {
        return dpConvertRetentionNums;
    }

    public void setDpConvertRetentionNums(String dpConvertRetentionNums) {
        this.dpConvertRetentionNums = dpConvertRetentionNums;
    }

    public String getDpConvertRetentionPrice() {
        return dpConvertRetentionPrice;
    }

    public void setDpConvertRetentionPrice(String dpConvertRetentionPrice) {
        this.dpConvertRetentionPrice = dpConvertRetentionPrice;
    }

    public String getQappQuickLnkNums() {
        return qappQuickLnkNums;
    }

    public void setQappQuickLnkNums(String qappQuickLnkNums) {
        this.qappQuickLnkNums = qappQuickLnkNums;
    }

    public String getQappQuickLnkPrice() {
        return qappQuickLnkPrice;
    }

    public void setQappQuickLnkPrice(String qappQuickLnkPrice) {
        this.qappQuickLnkPrice = qappQuickLnkPrice;
    }

    public String getQappLtv1() {
        return qappLtv1;
    }

    public void setQappLtv1(String qappLtv1) {
        this.qappLtv1 = qappLtv1;
    }

    public String getQappRoi1() {
        return qappRoi1;
    }

    public void setQappRoi1(String qappRoi1) {
        this.qappRoi1 = qappRoi1;
    }

    public String getQuickAppActNum() {
        return quickAppActNum;
    }

    public void setQuickAppActNum(String quickAppActNum) {
        this.quickAppActNum = quickAppActNum;
    }

    public String getQuickAppActCost() {
        return quickAppActCost;
    }

    public void setQuickAppActCost(String quickAppActCost) {
        this.quickAppActCost = quickAppActCost;
    }

    public String getConvertRetentionRate() {
        return convertRetentionRate;
    }

    public void setConvertRetentionRate(String convertRetentionRate) {
        this.convertRetentionRate = convertRetentionRate;
    }

    public String getFormKeyActNums() {
        return formKeyActNums;
    }

    public void setFormKeyActNums(String formKeyActNums) {
        this.formKeyActNums = formKeyActNums;
    }

    public String getFormKeyActPrice() {
        return formKeyActPrice;
    }

    public void setFormKeyActPrice(String formKeyActPrice) {
        this.formKeyActPrice = formKeyActPrice;
    }

    public String getEffectConsultNums() {
        return effectConsultNums;
    }

    public void setEffectConsultNums(String effectConsultNums) {
        this.effectConsultNums = effectConsultNums;
    }

    public String getEffectConsultPrice() {
        return effectConsultPrice;
    }

    public void setEffectConsultPrice(String effectConsultPrice) {
        this.effectConsultPrice = effectConsultPrice;
    }

    public String getWechatFocusNums() {
        return wechatFocusNums;
    }

    public void setWechatFocusNums(String wechatFocusNums) {
        this.wechatFocusNums = wechatFocusNums;
    }

    public String getWechatFocusPrice() {
        return wechatFocusPrice;
    }

    public void setWechatFocusPrice(String wechatFocusPrice) {
        this.wechatFocusPrice = wechatFocusPrice;
    }

    public String getWebPageBuyNums() {
        return webPageBuyNums;
    }

    public void setWebPageBuyNums(String webPageBuyNums) {
        this.webPageBuyNums = webPageBuyNums;
    }

    public String getWebPageBuyPrice() {
        return webPageBuyPrice;
    }

    public void setWebPageBuyPrice(String webPageBuyPrice) {
        this.webPageBuyPrice = webPageBuyPrice;
    }

    public String getCallUpNums() {
        return callUpNums;
    }

    public void setCallUpNums(String callUpNums) {
        this.callUpNums = callUpNums;
    }

    public String getCallUpPrice() {
        return callUpPrice;
    }

    public void setCallUpPrice(String callUpPrice) {
        this.callUpPrice = callUpPrice;
    }

    public String getGameAppActNums() {
        return gameAppActNums;
    }

    public void setGameAppActNums(String gameAppActNums) {
        this.gameAppActNums = gameAppActNums;
    }

    public String getGameAppActPrice() {
        return gameAppActPrice;
    }

    public void setGameAppActPrice(String gameAppActPrice) {
        this.gameAppActPrice = gameAppActPrice;
    }

    public String getDpConvertRetentionRate() {
        return dpConvertRetentionRate;
    }

    public void setDpConvertRetentionRate(String dpConvertRetentionRate) {
        this.dpConvertRetentionRate = dpConvertRetentionRate;
    }

    public String getWechatGameRegister() {
        return wechatGameRegister;
    }

    public void setWechatGameRegister(String wechatGameRegister) {
        this.wechatGameRegister = wechatGameRegister;
    }

    public String getWechatGameRegisterPrice() {
        return wechatGameRegisterPrice;
    }

    public void setWechatGameRegisterPrice(String wechatGameRegisterPrice) {
        this.wechatGameRegisterPrice = wechatGameRegisterPrice;
    }

    public String getWechatGamePay() {
        return wechatGamePay;
    }

    public void setWechatGamePay(String wechatGamePay) {
        this.wechatGamePay = wechatGamePay;
    }

    public String getWechatGamePayPrice() {
        return wechatGamePayPrice;
    }

    public void setWechatGamePayPrice(String wechatGamePayPrice) {
        this.wechatGamePayPrice = wechatGamePayPrice;
    }

    public String getPayNums() {
        return payNums;
    }

    public void setPayNums(String payNums) {
        this.payNums = payNums;
    }

    public String getPayPerPrice() {
        return payPerPrice;
    }

    public void setPayPerPrice(String payPerPrice) {
        this.payPerPrice = payPerPrice;
    }

    public String getConvertRetention3() {
        return convertRetention3;
    }

    public void setConvertRetention3(String convertRetention3) {
        this.convertRetention3 = convertRetention3;
    }

    public String getConvertRetention4() {
        return convertRetention4;
    }

    public void setConvertRetention4(String convertRetention4) {
        this.convertRetention4 = convertRetention4;
    }

    public String getConvertRetention5() {
        return convertRetention5;
    }

    public void setConvertRetention5(String convertRetention5) {
        this.convertRetention5 = convertRetention5;
    }

    public String getConvertRetention6() {
        return convertRetention6;
    }

    public void setConvertRetention6(String convertRetention6) {
        this.convertRetention6 = convertRetention6;
    }

    public String getConvertRetention7() {
        return convertRetention7;
    }

    public void setConvertRetention7(String convertRetention7) {
        this.convertRetention7 = convertRetention7;
    }

    public String getWechatGamePayCost() {
        return wechatGamePayCost;
    }

    public void setWechatGamePayCost(String wechatGamePayCost) {
        this.wechatGamePayCost = wechatGamePayCost;
    }

    public String getFirstPayNum() {
        return firstPayNum;
    }

    public void setFirstPayNum(String firstPayNum) {
        this.firstPayNum = firstPayNum;
    }

    public String getWechatGameRoi1() {
        return wechatGameRoi1;
    }

    public void setWechatGameRoi1(String wechatGameRoi1) {
        this.wechatGameRoi1 = wechatGameRoi1;
    }

    public String getConvertRetention3Rate() {
        return convertRetention3Rate;
    }

    public void setConvertRetention3Rate(String convertRetention3Rate) {
        this.convertRetention3Rate = convertRetention3Rate;
    }

    public String getConvertRetention4Rate() {
        return convertRetention4Rate;
    }

    public void setConvertRetention4Rate(String convertRetention4Rate) {
        this.convertRetention4Rate = convertRetention4Rate;
    }

    public String getConvertRetention5Rate() {
        return convertRetention5Rate;
    }

    public void setConvertRetention5Rate(String convertRetention5Rate) {
        this.convertRetention5Rate = convertRetention5Rate;
    }

    public String getConvertRetention6Rate() {
        return convertRetention6Rate;
    }

    public void setConvertRetention6Rate(String convertRetention6Rate) {
        this.convertRetention6Rate = convertRetention6Rate;
    }

    public String getConvertRetention7Rate() {
        return convertRetention7Rate;
    }

    public void setConvertRetention7Rate(String convertRetention7Rate) {
        this.convertRetention7Rate = convertRetention7Rate;
    }

    public String getLt7() {
        return lt7;
    }

    public void setLt7(String lt7) {
        this.lt7 = lt7;
    }

    public String getLt7Rate() {
        return lt7Rate;
    }

    public void setLt7Rate(String lt7Rate) {
        this.lt7Rate = lt7Rate;
    }

    public String getRegisterAppPayRate() {
        return registerAppPayRate;
    }

    public void setRegisterAppPayRate(String registerAppPayRate) {
        this.registerAppPayRate = registerAppPayRate;
    }

    public String getBookNums() {
        return bookNums;
    }

    public void setBookNums(String bookNums) {
        this.bookNums = bookNums;
    }

    public String getCancelBookNums() {
        return cancelBookNums;
    }

    public void setCancelBookNums(String cancelBookNums) {
        this.cancelBookNums = cancelBookNums;
    }

    public String getBookDownloadNums() {
        return bookDownloadNums;
    }

    public void setBookDownloadNums(String bookDownloadNums) {
        this.bookDownloadNums = bookDownloadNums;
    }

    public String getConvertLongRetentionNums() {
        return convertLongRetentionNums;
    }

    public void setConvertLongRetentionNums(String convertLongRetentionNums) {
        this.convertLongRetentionNums = convertLongRetentionNums;
    }

    public String getConvertLongRetentionPrice() {
        return convertLongRetentionPrice;
    }

    public void setConvertLongRetentionPrice(String convertLongRetentionPrice) {
        this.convertLongRetentionPrice = convertLongRetentionPrice;
    }

    public String getConvertPerPayNums() {
        return convertPerPayNums;
    }

    public void setConvertPerPayNums(String convertPerPayNums) {
        this.convertPerPayNums = convertPerPayNums;
    }

    public String getConvertPerPayPrice() {
        return convertPerPayPrice;
    }

    public void setConvertPerPayPrice(String convertPerPayPrice) {
        this.convertPerPayPrice = convertPerPayPrice;
    }

    public String getRoi14() {
        return roi14;
    }

    public void setRoi14(String roi14) {
        this.roi14 = roi14;
    }

    public String getLtv14() {
        return ltv14;
    }

    public void setLtv14(String ltv14) {
        this.ltv14 = ltv14;
    }

    public String getCateName() {
        return cateName;
    }

    public void setCateName(String cateName) {
        this.cateName = cateName;
    }

    public String getSubCateName() {
        return subCateName;
    }

    public void setSubCateName(String subCateName) {
        this.subCateName = subCateName;
    }

    public String getThirdCateName() {
        return thirdCateName;
    }

    public void setThirdCateName(String thirdCateName) {
        this.thirdCateName = thirdCateName;
    }

    public String getQuickAppActRate() {
        return quickAppActRate;
    }

    public void setQuickAppActRate(String quickAppActRate) {
        this.quickAppActRate = quickAppActRate;
    }

    public String getConvertPayCost() {
        return convertPayCost;
    }

    public void setConvertPayCost(String convertPayCost) {
        this.convertPayCost = convertPayCost;
    }

    public String getAppRoi() {
        return appRoi;
    }

    public void setAppRoi(String appRoi) {
        this.appRoi = appRoi;
    }
}
