package com.omni.ads.model.adscreativity;

import com.omni.ads.anno.CommonRage;
import com.omni.ads.model.adsgroup.ValidationGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Set;


@ApiModel("广告创意列表请求对象")
public class AdsAdListForm implements Serializable {

    private static final long serialVersionUID = 2526371084475859233L;

    @ApiParam(value = "展示状态列表，启动中-0 暂停中-1 广告组暂停-2 计划暂停-3")
    private Set<Integer> showStatusSet;
    @ApiParam(value = "审核状态列表,审核中-0 审核拒绝-2")
    private Set<Integer> auditStatusSet;
    @ApiParam(value = "是否删除,0 未删除 1 删除", hidden = true)
    private Integer deleteFlag = 0;

    @ApiParam(value = "广告计划ID列表")
    private Set<Long> planIds;
    @ApiParam(value = "广告计划名称", hidden = true)
    private String planNameLike;
    @ApiParam(value = "广告组ID列表")
    private Set<Long> adGroupIds;
    @ApiParam(value = "广告组名称", hidden = true)
    private String adGroupNameLike;

    @ApiParam(value = "广告ID列表")
    private List<Long> adIds;

    @ApiParam(value = "广告名称")
    private String adNameLike;

    @ApiParam(value = "推广目标列表，1-链接推广 2-应用推广 3-快应用推广")
    private Set<Integer> extensionTypes;
    @ApiParam(value = "推广流量列表，1-全流量 2-自有流量 3-联盟流量")
    private Set<Integer> extensionFlows;
    @ApiParam(value = "流量场景列表，1-全流量场景 2-精选推广 3-安装有礼 4-开机必备 5-搜索 6-信息流 7-banner 8-开屏 9-插屏 10-原生(联盟）11-激励视频 12-投类型")
    private Set<Integer> flowScenes;
    @ApiParam(value = "创意规格列表，/spec/list规格查询接口返回，另可参考附录-规格部分")
    private Set<Integer> globalSpecIds;

    @ApiParam(value = "开始日期，如20210621")
    @Range(min = 10000000, max = 99999999, groups = ValidationGroup.Find.class)
    private Long beginTime;
    @ApiParam(value = "结束日期，如20210621")
    @Range(min = 10000000, max = 99999999, groups = ValidationGroup.Find.class)
    private Long endTime;

    @ApiParam(value = "排序的数据列")
    private String orderByColumn;

    @ApiParam(value = "排序方式,ASC-顺序 DESC-逆序")
    @CommonRage(values = {"ASC", "DESC"}, groups = ValidationGroup.Find.class)
    private String asc;

    @ApiParam(value = "是否查询数据字段，0表示不查询，1表示查询", hidden = true)
    @Min(value = 0, groups = ValidationGroup.Find.class)
    @Max(value = 1, groups = ValidationGroup.Find.class)
    private Integer needStats;

    @ApiParam(value ="分页查询起始页，起始页从1开始", required = true)
    @NotNull(message = "分页参数 页号 page 不能为空")
    @Min(value = 1, groups = {ValidationGroup.Find.class}, message = "页码必须大于等于1")
    private Integer page;

    @ApiParam(value ="页大小 最大只支持1000", required = true)
    @NotNull(message = "分页参数 页大小 limit 不能为空")
    @Min(value = 1, groups = {ValidationGroup.Find.class}, message = "分页大小必须大于等于1")
    @Max(value = 1000, groups = ValidationGroup.Find.class, message = "分页大小最大只支持1000")
    private Integer limit;

    @ApiParam(value = "过滤消耗金额为0的数据，0表示不过滤，1表示过滤", hidden = true)
    @Min(value = 0, groups = ValidationGroup.Find.class)
    @Max(value = 1, groups = ValidationGroup.Find.class)
    private Integer filterZero = 0;
    @ApiParam(value = "消耗金额下限", hidden = true)
    private String costFloor;
    @ApiParam(value = "消耗金额上限", hidden = true)
    private String costCeiling;
    @ApiParam(value = "曝光量下限", hidden = true)
    private String exposeFloor;
    @ApiParam(value = "曝光量上限", hidden = true)
    private String exposeCeiling;
    @ApiParam(value = "点击量下限", hidden = true)
    private String clickFloor;
    @ApiParam(value = "点击量上限", hidden = true)
    private String clickCeiling;
    @ApiParam(value = "点击率下限", hidden = true)
    private String clickRateFloor;
    @ApiParam(value = "点击率下限", hidden = true)
    private String clickRateCeiling;
    @ApiParam(value = "下载量下限", hidden = true)
    private String downloadFloor;
    @ApiParam(value = "下载量上限", hidden = true)
    private String downloadCeiling;
    @ApiParam(value = "下载率下限", hidden = true)
    private String downloadRateFloor;
    @ApiParam(value = "下载率上限", hidden = true)
    private String downloadRateCeiling;
    @ApiParam(value = "ecpm下限", hidden = true)
    private String ecpmCeiling;
    @ApiParam(value = "ecpm上限", hidden = true)
    private String ecpmFloor;
    @ApiParam(value = "表单提交量下限", hidden = true)
    private String formCntFloor;
    @ApiParam(value = "表单提交量上限", hidden = true)
    private String formCntCeiling;
    @ApiParam(value = "表单提交成本下限", hidden = true)
    private String formCntPriceFloor;
    @ApiParam(value = "表单提交成本上限", hidden = true)
    private String formCntPriceCeiling;
    @ApiParam(value = "回传激活量下限", hidden = true)
    private String convertActiveFloor;
    @ApiParam(value = "回传激活量上限", hidden = true)
    private String convertActiveCeiling;
    @ApiParam(value = "回传激活成本下限", hidden = true)
    private String convertActivePriceFloor;
    @ApiParam(value = "回传激活成本上限", hidden = true)
    private String convertActivePriceCeiling;
    @ApiParam(value = "注册量下限", hidden = true)
    private String convertRegisterFloor;
    @ApiParam(value = "注册量上限", hidden = true)
    private String convertRegisterCeiling;
    @ApiParam(value = "注册成本下限", hidden = true)
    private String convertRegisterPriceFloor;
    @ApiParam(value = "注册成本上限", hidden = true)
    private String convertRegisterPriceCeiling;
    @ApiParam(value = "回传留存下限", hidden = true)
    private String convertRetentionFloor;
    @ApiParam(value = "回传留存上限", hidden = true)
    private String convertRetentionCeiling;
    @ApiParam(value = "回传留存成本下限", hidden = true)
    private String convertRetentionPriceFloor;
    @ApiParam(value = "回传留存成本上限", hidden = true)
    private String convertRetentionPriceCeiling;
    @ApiParam(value = "应用内授信下限", hidden = true)
    private String convertAppCreditFloor;
    @ApiParam(value = "应用内授信上限", hidden = true)
    private String convertAppCreditCeiling;
    @ApiParam(value = "应用内授信成本下限", hidden = true)
    private String convertAppCreditPriceFloor;
    @ApiParam(value = "应用内授信成本上限", hidden = true)
    private String convertAppCreditPriceCeiling;
    @ApiParam(value = "应用内下单（电商）下限", hidden = true)
    private String convertAppOrderFloor;
    @ApiParam(value = "应用内下单（电商）上限", hidden = true)
    private String convertAppOrderCeiling;
    @ApiParam(value = "应用内下单（电商）成本下限", hidden = true)
    private String convertAppOrderPriceFloor;
    @ApiParam(value = "应用内下单（电商）成本上限", hidden = true)
    private String convertAppOrderPriceCeiling;
    @ApiParam(value = "应用内付费下限", hidden = true)
    private String convertAppPayFloor;
    @ApiParam(value = "应用内付费上限", hidden = true)
    private String convertAppPayCeiling;
    @ApiParam(value = "应用内付费成本下限", hidden = true)
    private String convertAppPayPriceFloor;
    @ApiParam(value = "应用内付费成本上限", hidden = true)
    private String convertAppPayPriceCeiling;
    @ApiParam(value = "应用内自定义转化下限", hidden = true)
    private String convertAppCustomFloor;
    @ApiParam(value = "应用内自定义转化上限", hidden = true)
    private String convertAppCustomCeiling;
    @ApiParam(value = "应用内自定义转化成本下限", hidden = true)
    private String convertAppCustomPriceFloor;
    @ApiParam(value = "应用内自定义转化成本上限", hidden = true)
    private String convertAppCustomPriceCeiling;
    @ApiParam(value = "回传拉活下限", hidden = true)
    private String convertDpFloor;
    @ApiParam(value = "回传拉活上限", hidden = true)
    private String convertDpCeiling;
    @ApiParam(value = "回传拉活成本下限", hidden = true)
    private String convertDpPriceFloor;
    @ApiParam(value = "回传拉活成本上限", hidden = true)
    private String convertDpPriceCeiling;
    @ApiParam(value = "deeplink回传激活量下限", hidden = true)
    private String dpConvertActivationNumsFloor;
    @ApiParam(value = "deeplink回传激活量上限", hidden = true)
    private String dpConvertActivationNumsCeiling;
    @ApiParam(value = "deeplink回传激活成本下限", hidden = true)
    private String dpConvertActivationPriceFloor;
    @ApiParam(value = "deeplink回传激活成本上限", hidden = true)
    private String dpConvertActivationPriceCeiling;
    @ApiParam(value = "deeplink回传注册量下限", hidden = true)
    private String dpConvertRegisterNumsFloor;
    @ApiParam(value = "deeplink回传注册量上限", hidden = true)
    private String dpConvertRegisterNumsCeiling;
    @ApiParam(value = "deeplink回传注册成本下限", hidden = true)
    private String dpConvertRegisterPriceFloor;
    @ApiParam(value = "deeplink回传注册成本上限", hidden = true)
    private String dpConvertRegisterPriceCeiling;
    @ApiParam(value = "deeplink应用付费量下限", hidden = true)
    private String dpAppPayNumsFloor;
    @ApiParam(value = "deeplink应用付费量上限", hidden = true)
    private String dpAppPayNumsCeiling;
    @ApiParam(value = "deeplink应用付费成本下限", hidden = true)
    private String dpAppPayPriceFloor;
    @ApiParam(value = "deeplink应用付费成本上限", hidden = true)
    private String dpAppPayPriceCeiling;
    @ApiParam(value = "deeplink自定义转化量下限", hidden = true)
    private String dpUdConvertNumsFloor;
    @ApiParam(value = "deeplink自定义转化量上限", hidden = true)
    private String dpUdConvertNumsCeiling;
    @ApiParam(value = "deeplink自定义转化成本下限", hidden = true)
    private String dpUdConvertPriceFloor;
    @ApiParam(value = "deeplink自定义转化成本上限", hidden = true)
    private String dpUdConvertPriceCeiling;
    @ApiParam(value = "deeplink应用内授信量下限", hidden = true)
    private String dpAppCreditNumsFloor;
    @ApiParam(value = "deeplink应用内授信量上限", hidden = true)
    private String dpAppCreditNumsCeiling;
    @ApiParam(value = "deeplink应用内授信成本下限", hidden = true)
    private String dpAppCreditPriceFloor;
    @ApiParam(value = "deeplink应用内授信成本上限", hidden = true)
    private String dpAppCreditPriceCeiling;
    @ApiParam(value = "deeplink应用内下单量下限", hidden = true)
    private String dpAppOrderNumsFloor;
    @ApiParam(value = "deeplink应用内下单量上限", hidden = true)
    private String dpAppOrderNumsCeiling;
    @ApiParam(value = "deeplink应用内下单成本下限", hidden = true)
    private String dpAppOrderPriceFloor;
    @ApiParam(value = "deeplink应用内下单成本上限", hidden = true)
    private String dpAppOrderPriceCeiling;
    @ApiParam(value = "快应用付费下限", hidden = true)
    private String quickAppPayFloor;
    @ApiParam(value = "快应用付费上限", hidden = true)
    private String quickAppPayCeiling;
    @ApiParam(value = "快应用付费成本下限", hidden = true)
    private String quickAppPayPriceFloor;
    @ApiParam(value = "快应用付费成本上限", hidden = true)
    private String quickAppPayPriceCeiling;

    public Set<Integer> getShowStatusSet() {
        return showStatusSet;
    }

    public void setShowStatusSet(Set<Integer> showStatusSet) {
        this.showStatusSet = showStatusSet;
    }

    public Set<Integer> getAuditStatusSet() {
        return auditStatusSet;
    }

    public void setAuditStatusSet(Set<Integer> auditStatusSet) {
        this.auditStatusSet = auditStatusSet;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Set<Long> getPlanIds() {
        return planIds;
    }

    public void setPlanIds(Set<Long> planIds) {
        this.planIds = planIds;
    }

    public String getPlanNameLike() {
        return planNameLike;
    }

    public void setPlanNameLike(String planNameLike) {
        this.planNameLike = planNameLike;
    }

    public Set<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public void setAdGroupIds(Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
    }

    public String getAdGroupNameLike() {
        return adGroupNameLike;
    }

    public void setAdGroupNameLike(String adGroupNameLike) {
        this.adGroupNameLike = adGroupNameLike;
    }

    public List<Long> getAdIds() {
        return adIds;
    }

    public void setAdIds(List<Long> adIds) {
        this.adIds = adIds;
    }

    public String getAdNameLike() {
        return adNameLike;
    }

    public void setAdNameLike(String adNameLike) {
        this.adNameLike = adNameLike;
    }

    public Set<Integer> getExtensionTypes() {
        return extensionTypes;
    }

    public void setExtensionTypes(Set<Integer> extensionTypes) {
        this.extensionTypes = extensionTypes;
    }

    public Set<Integer> getExtensionFlows() {
        return extensionFlows;
    }

    public void setExtensionFlows(Set<Integer> extensionFlows) {
        this.extensionFlows = extensionFlows;
    }

    public Set<Integer> getFlowScenes() {
        return flowScenes;
    }

    public void setFlowScenes(Set<Integer> flowScenes) {
        this.flowScenes = flowScenes;
    }

    public Set<Integer> getGlobalSpecIds() {
        return globalSpecIds;
    }

    public void setGlobalSpecIds(Set<Integer> globalSpecIds) {
        this.globalSpecIds = globalSpecIds;
    }

    public Long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Long beginTime) {
        this.beginTime = beginTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getOrderByColumn() {
        return orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getAsc() {
        return asc;
    }

    public void setAsc(String asc) {
        this.asc = asc;
    }

    public Integer getNeedStats() {
        return needStats;
    }

    public void setNeedStats(Integer needStats) {
        this.needStats = needStats;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getFilterZero() {
        return filterZero;
    }

    public void setFilterZero(Integer filterZero) {
        this.filterZero = filterZero;
    }

    public String getCostFloor() {
        return costFloor;
    }

    public void setCostFloor(String costFloor) {
        this.costFloor = costFloor;
    }

    public String getCostCeiling() {
        return costCeiling;
    }

    public void setCostCeiling(String costCeiling) {
        this.costCeiling = costCeiling;
    }

    public String getExposeFloor() {
        return exposeFloor;
    }

    public void setExposeFloor(String exposeFloor) {
        this.exposeFloor = exposeFloor;
    }

    public String getExposeCeiling() {
        return exposeCeiling;
    }

    public void setExposeCeiling(String exposeCeiling) {
        this.exposeCeiling = exposeCeiling;
    }

    public String getClickFloor() {
        return clickFloor;
    }

    public void setClickFloor(String clickFloor) {
        this.clickFloor = clickFloor;
    }

    public String getClickCeiling() {
        return clickCeiling;
    }

    public void setClickCeiling(String clickCeiling) {
        this.clickCeiling = clickCeiling;
    }

    public String getClickRateFloor() {
        return clickRateFloor;
    }

    public void setClickRateFloor(String clickRateFloor) {
        this.clickRateFloor = clickRateFloor;
    }

    public String getClickRateCeiling() {
        return clickRateCeiling;
    }

    public void setClickRateCeiling(String clickRateCeiling) {
        this.clickRateCeiling = clickRateCeiling;
    }

    public String getDownloadFloor() {
        return downloadFloor;
    }

    public void setDownloadFloor(String downloadFloor) {
        this.downloadFloor = downloadFloor;
    }

    public String getDownloadCeiling() {
        return downloadCeiling;
    }

    public void setDownloadCeiling(String downloadCeiling) {
        this.downloadCeiling = downloadCeiling;
    }

    public String getDownloadRateFloor() {
        return downloadRateFloor;
    }

    public void setDownloadRateFloor(String downloadRateFloor) {
        this.downloadRateFloor = downloadRateFloor;
    }

    public String getDownloadRateCeiling() {
        return downloadRateCeiling;
    }

    public void setDownloadRateCeiling(String downloadRateCeiling) {
        this.downloadRateCeiling = downloadRateCeiling;
    }

    public String getEcpmCeiling() {
        return ecpmCeiling;
    }

    public void setEcpmCeiling(String ecpmCeiling) {
        this.ecpmCeiling = ecpmCeiling;
    }

    public String getEcpmFloor() {
        return ecpmFloor;
    }

    public void setEcpmFloor(String ecpmFloor) {
        this.ecpmFloor = ecpmFloor;
    }

    public String getFormCntFloor() {
        return formCntFloor;
    }

    public void setFormCntFloor(String formCntFloor) {
        this.formCntFloor = formCntFloor;
    }

    public String getFormCntCeiling() {
        return formCntCeiling;
    }

    public void setFormCntCeiling(String formCntCeiling) {
        this.formCntCeiling = formCntCeiling;
    }

    public String getFormCntPriceFloor() {
        return formCntPriceFloor;
    }

    public void setFormCntPriceFloor(String formCntPriceFloor) {
        this.formCntPriceFloor = formCntPriceFloor;
    }

    public String getFormCntPriceCeiling() {
        return formCntPriceCeiling;
    }

    public void setFormCntPriceCeiling(String formCntPriceCeiling) {
        this.formCntPriceCeiling = formCntPriceCeiling;
    }

    public String getConvertActiveFloor() {
        return convertActiveFloor;
    }

    public void setConvertActiveFloor(String convertActiveFloor) {
        this.convertActiveFloor = convertActiveFloor;
    }

    public String getConvertActiveCeiling() {
        return convertActiveCeiling;
    }

    public void setConvertActiveCeiling(String convertActiveCeiling) {
        this.convertActiveCeiling = convertActiveCeiling;
    }

    public String getConvertActivePriceFloor() {
        return convertActivePriceFloor;
    }

    public void setConvertActivePriceFloor(String convertActivePriceFloor) {
        this.convertActivePriceFloor = convertActivePriceFloor;
    }

    public String getConvertActivePriceCeiling() {
        return convertActivePriceCeiling;
    }

    public void setConvertActivePriceCeiling(String convertActivePriceCeiling) {
        this.convertActivePriceCeiling = convertActivePriceCeiling;
    }

    public String getConvertRegisterFloor() {
        return convertRegisterFloor;
    }

    public void setConvertRegisterFloor(String convertRegisterFloor) {
        this.convertRegisterFloor = convertRegisterFloor;
    }

    public String getConvertRegisterCeiling() {
        return convertRegisterCeiling;
    }

    public void setConvertRegisterCeiling(String convertRegisterCeiling) {
        this.convertRegisterCeiling = convertRegisterCeiling;
    }

    public String getConvertRegisterPriceFloor() {
        return convertRegisterPriceFloor;
    }

    public void setConvertRegisterPriceFloor(String convertRegisterPriceFloor) {
        this.convertRegisterPriceFloor = convertRegisterPriceFloor;
    }

    public String getConvertRegisterPriceCeiling() {
        return convertRegisterPriceCeiling;
    }

    public void setConvertRegisterPriceCeiling(String convertRegisterPriceCeiling) {
        this.convertRegisterPriceCeiling = convertRegisterPriceCeiling;
    }

    public String getConvertRetentionFloor() {
        return convertRetentionFloor;
    }

    public void setConvertRetentionFloor(String convertRetentionFloor) {
        this.convertRetentionFloor = convertRetentionFloor;
    }

    public String getConvertRetentionCeiling() {
        return convertRetentionCeiling;
    }

    public void setConvertRetentionCeiling(String convertRetentionCeiling) {
        this.convertRetentionCeiling = convertRetentionCeiling;
    }

    public String getConvertRetentionPriceFloor() {
        return convertRetentionPriceFloor;
    }

    public void setConvertRetentionPriceFloor(String convertRetentionPriceFloor) {
        this.convertRetentionPriceFloor = convertRetentionPriceFloor;
    }

    public String getConvertRetentionPriceCeiling() {
        return convertRetentionPriceCeiling;
    }

    public void setConvertRetentionPriceCeiling(String convertRetentionPriceCeiling) {
        this.convertRetentionPriceCeiling = convertRetentionPriceCeiling;
    }

    public String getConvertAppCreditFloor() {
        return convertAppCreditFloor;
    }

    public void setConvertAppCreditFloor(String convertAppCreditFloor) {
        this.convertAppCreditFloor = convertAppCreditFloor;
    }

    public String getConvertAppCreditCeiling() {
        return convertAppCreditCeiling;
    }

    public void setConvertAppCreditCeiling(String convertAppCreditCeiling) {
        this.convertAppCreditCeiling = convertAppCreditCeiling;
    }

    public String getConvertAppCreditPriceFloor() {
        return convertAppCreditPriceFloor;
    }

    public void setConvertAppCreditPriceFloor(String convertAppCreditPriceFloor) {
        this.convertAppCreditPriceFloor = convertAppCreditPriceFloor;
    }

    public String getConvertAppCreditPriceCeiling() {
        return convertAppCreditPriceCeiling;
    }

    public void setConvertAppCreditPriceCeiling(String convertAppCreditPriceCeiling) {
        this.convertAppCreditPriceCeiling = convertAppCreditPriceCeiling;
    }

    public String getConvertAppOrderFloor() {
        return convertAppOrderFloor;
    }

    public void setConvertAppOrderFloor(String convertAppOrderFloor) {
        this.convertAppOrderFloor = convertAppOrderFloor;
    }

    public String getConvertAppOrderCeiling() {
        return convertAppOrderCeiling;
    }

    public void setConvertAppOrderCeiling(String convertAppOrderCeiling) {
        this.convertAppOrderCeiling = convertAppOrderCeiling;
    }

    public String getConvertAppOrderPriceFloor() {
        return convertAppOrderPriceFloor;
    }

    public void setConvertAppOrderPriceFloor(String convertAppOrderPriceFloor) {
        this.convertAppOrderPriceFloor = convertAppOrderPriceFloor;
    }

    public String getConvertAppOrderPriceCeiling() {
        return convertAppOrderPriceCeiling;
    }

    public void setConvertAppOrderPriceCeiling(String convertAppOrderPriceCeiling) {
        this.convertAppOrderPriceCeiling = convertAppOrderPriceCeiling;
    }

    public String getConvertAppPayFloor() {
        return convertAppPayFloor;
    }

    public void setConvertAppPayFloor(String convertAppPayFloor) {
        this.convertAppPayFloor = convertAppPayFloor;
    }

    public String getConvertAppPayCeiling() {
        return convertAppPayCeiling;
    }

    public void setConvertAppPayCeiling(String convertAppPayCeiling) {
        this.convertAppPayCeiling = convertAppPayCeiling;
    }

    public String getConvertAppPayPriceFloor() {
        return convertAppPayPriceFloor;
    }

    public void setConvertAppPayPriceFloor(String convertAppPayPriceFloor) {
        this.convertAppPayPriceFloor = convertAppPayPriceFloor;
    }

    public String getConvertAppPayPriceCeiling() {
        return convertAppPayPriceCeiling;
    }

    public void setConvertAppPayPriceCeiling(String convertAppPayPriceCeiling) {
        this.convertAppPayPriceCeiling = convertAppPayPriceCeiling;
    }

    public String getConvertAppCustomFloor() {
        return convertAppCustomFloor;
    }

    public void setConvertAppCustomFloor(String convertAppCustomFloor) {
        this.convertAppCustomFloor = convertAppCustomFloor;
    }

    public String getConvertAppCustomCeiling() {
        return convertAppCustomCeiling;
    }

    public void setConvertAppCustomCeiling(String convertAppCustomCeiling) {
        this.convertAppCustomCeiling = convertAppCustomCeiling;
    }

    public String getConvertAppCustomPriceFloor() {
        return convertAppCustomPriceFloor;
    }

    public void setConvertAppCustomPriceFloor(String convertAppCustomPriceFloor) {
        this.convertAppCustomPriceFloor = convertAppCustomPriceFloor;
    }

    public String getConvertAppCustomPriceCeiling() {
        return convertAppCustomPriceCeiling;
    }

    public void setConvertAppCustomPriceCeiling(String convertAppCustomPriceCeiling) {
        this.convertAppCustomPriceCeiling = convertAppCustomPriceCeiling;
    }

    public String getConvertDpFloor() {
        return convertDpFloor;
    }

    public void setConvertDpFloor(String convertDpFloor) {
        this.convertDpFloor = convertDpFloor;
    }

    public String getConvertDpCeiling() {
        return convertDpCeiling;
    }

    public void setConvertDpCeiling(String convertDpCeiling) {
        this.convertDpCeiling = convertDpCeiling;
    }

    public String getConvertDpPriceFloor() {
        return convertDpPriceFloor;
    }

    public void setConvertDpPriceFloor(String convertDpPriceFloor) {
        this.convertDpPriceFloor = convertDpPriceFloor;
    }

    public String getConvertDpPriceCeiling() {
        return convertDpPriceCeiling;
    }

    public void setConvertDpPriceCeiling(String convertDpPriceCeiling) {
        this.convertDpPriceCeiling = convertDpPriceCeiling;
    }

    public String getDpConvertActivationNumsFloor() {
        return dpConvertActivationNumsFloor;
    }

    public void setDpConvertActivationNumsFloor(String dpConvertActivationNumsFloor) {
        this.dpConvertActivationNumsFloor = dpConvertActivationNumsFloor;
    }

    public String getDpConvertActivationNumsCeiling() {
        return dpConvertActivationNumsCeiling;
    }

    public void setDpConvertActivationNumsCeiling(String dpConvertActivationNumsCeiling) {
        this.dpConvertActivationNumsCeiling = dpConvertActivationNumsCeiling;
    }

    public String getDpConvertActivationPriceFloor() {
        return dpConvertActivationPriceFloor;
    }

    public void setDpConvertActivationPriceFloor(String dpConvertActivationPriceFloor) {
        this.dpConvertActivationPriceFloor = dpConvertActivationPriceFloor;
    }

    public String getDpConvertActivationPriceCeiling() {
        return dpConvertActivationPriceCeiling;
    }

    public void setDpConvertActivationPriceCeiling(String dpConvertActivationPriceCeiling) {
        this.dpConvertActivationPriceCeiling = dpConvertActivationPriceCeiling;
    }

    public String getDpConvertRegisterNumsFloor() {
        return dpConvertRegisterNumsFloor;
    }

    public void setDpConvertRegisterNumsFloor(String dpConvertRegisterNumsFloor) {
        this.dpConvertRegisterNumsFloor = dpConvertRegisterNumsFloor;
    }

    public String getDpConvertRegisterNumsCeiling() {
        return dpConvertRegisterNumsCeiling;
    }

    public void setDpConvertRegisterNumsCeiling(String dpConvertRegisterNumsCeiling) {
        this.dpConvertRegisterNumsCeiling = dpConvertRegisterNumsCeiling;
    }

    public String getDpConvertRegisterPriceFloor() {
        return dpConvertRegisterPriceFloor;
    }

    public void setDpConvertRegisterPriceFloor(String dpConvertRegisterPriceFloor) {
        this.dpConvertRegisterPriceFloor = dpConvertRegisterPriceFloor;
    }

    public String getDpConvertRegisterPriceCeiling() {
        return dpConvertRegisterPriceCeiling;
    }

    public void setDpConvertRegisterPriceCeiling(String dpConvertRegisterPriceCeiling) {
        this.dpConvertRegisterPriceCeiling = dpConvertRegisterPriceCeiling;
    }

    public String getDpAppPayNumsFloor() {
        return dpAppPayNumsFloor;
    }

    public void setDpAppPayNumsFloor(String dpAppPayNumsFloor) {
        this.dpAppPayNumsFloor = dpAppPayNumsFloor;
    }

    public String getDpAppPayNumsCeiling() {
        return dpAppPayNumsCeiling;
    }

    public void setDpAppPayNumsCeiling(String dpAppPayNumsCeiling) {
        this.dpAppPayNumsCeiling = dpAppPayNumsCeiling;
    }

    public String getDpAppPayPriceFloor() {
        return dpAppPayPriceFloor;
    }

    public void setDpAppPayPriceFloor(String dpAppPayPriceFloor) {
        this.dpAppPayPriceFloor = dpAppPayPriceFloor;
    }

    public String getDpAppPayPriceCeiling() {
        return dpAppPayPriceCeiling;
    }

    public void setDpAppPayPriceCeiling(String dpAppPayPriceCeiling) {
        this.dpAppPayPriceCeiling = dpAppPayPriceCeiling;
    }

    public String getDpUdConvertNumsFloor() {
        return dpUdConvertNumsFloor;
    }

    public void setDpUdConvertNumsFloor(String dpUdConvertNumsFloor) {
        this.dpUdConvertNumsFloor = dpUdConvertNumsFloor;
    }

    public String getDpUdConvertNumsCeiling() {
        return dpUdConvertNumsCeiling;
    }

    public void setDpUdConvertNumsCeiling(String dpUdConvertNumsCeiling) {
        this.dpUdConvertNumsCeiling = dpUdConvertNumsCeiling;
    }

    public String getDpUdConvertPriceFloor() {
        return dpUdConvertPriceFloor;
    }

    public void setDpUdConvertPriceFloor(String dpUdConvertPriceFloor) {
        this.dpUdConvertPriceFloor = dpUdConvertPriceFloor;
    }

    public String getDpUdConvertPriceCeiling() {
        return dpUdConvertPriceCeiling;
    }

    public void setDpUdConvertPriceCeiling(String dpUdConvertPriceCeiling) {
        this.dpUdConvertPriceCeiling = dpUdConvertPriceCeiling;
    }

    public String getDpAppCreditNumsFloor() {
        return dpAppCreditNumsFloor;
    }

    public void setDpAppCreditNumsFloor(String dpAppCreditNumsFloor) {
        this.dpAppCreditNumsFloor = dpAppCreditNumsFloor;
    }

    public String getDpAppCreditNumsCeiling() {
        return dpAppCreditNumsCeiling;
    }

    public void setDpAppCreditNumsCeiling(String dpAppCreditNumsCeiling) {
        this.dpAppCreditNumsCeiling = dpAppCreditNumsCeiling;
    }

    public String getDpAppCreditPriceFloor() {
        return dpAppCreditPriceFloor;
    }

    public void setDpAppCreditPriceFloor(String dpAppCreditPriceFloor) {
        this.dpAppCreditPriceFloor = dpAppCreditPriceFloor;
    }

    public String getDpAppCreditPriceCeiling() {
        return dpAppCreditPriceCeiling;
    }

    public void setDpAppCreditPriceCeiling(String dpAppCreditPriceCeiling) {
        this.dpAppCreditPriceCeiling = dpAppCreditPriceCeiling;
    }

    public String getDpAppOrderNumsFloor() {
        return dpAppOrderNumsFloor;
    }

    public void setDpAppOrderNumsFloor(String dpAppOrderNumsFloor) {
        this.dpAppOrderNumsFloor = dpAppOrderNumsFloor;
    }

    public String getDpAppOrderNumsCeiling() {
        return dpAppOrderNumsCeiling;
    }

    public void setDpAppOrderNumsCeiling(String dpAppOrderNumsCeiling) {
        this.dpAppOrderNumsCeiling = dpAppOrderNumsCeiling;
    }

    public String getDpAppOrderPriceFloor() {
        return dpAppOrderPriceFloor;
    }

    public void setDpAppOrderPriceFloor(String dpAppOrderPriceFloor) {
        this.dpAppOrderPriceFloor = dpAppOrderPriceFloor;
    }

    public String getDpAppOrderPriceCeiling() {
        return dpAppOrderPriceCeiling;
    }

    public void setDpAppOrderPriceCeiling(String dpAppOrderPriceCeiling) {
        this.dpAppOrderPriceCeiling = dpAppOrderPriceCeiling;
    }

    public String getQuickAppPayFloor() {
        return quickAppPayFloor;
    }

    public void setQuickAppPayFloor(String quickAppPayFloor) {
        this.quickAppPayFloor = quickAppPayFloor;
    }

    public String getQuickAppPayCeiling() {
        return quickAppPayCeiling;
    }

    public void setQuickAppPayCeiling(String quickAppPayCeiling) {
        this.quickAppPayCeiling = quickAppPayCeiling;
    }

    public String getQuickAppPayPriceFloor() {
        return quickAppPayPriceFloor;
    }

    public void setQuickAppPayPriceFloor(String quickAppPayPriceFloor) {
        this.quickAppPayPriceFloor = quickAppPayPriceFloor;
    }

    public String getQuickAppPayPriceCeiling() {
        return quickAppPayPriceCeiling;
    }

    public void setQuickAppPayPriceCeiling(String quickAppPayPriceCeiling) {
        this.quickAppPayPriceCeiling = quickAppPayPriceCeiling;
    }
}
