package com.omni.ads.model.adscreativity;

import com.omni.ads.model.adsgroup.ValidationGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;


import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@ApiModel("广告创意批量复制请求对象")
public class AdsAdReplicateForm implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiParam(value = "需要复制的广告id列表", required = true)
    @NotEmpty(groups = {ValidationGroup.BatchReplicate.class})
    private List<Long> adIds; // 广告id列表

    @ApiParam(value = "复制到目标广告组id", required = true)
    @NotNull(groups = {ValidationGroup.BatchReplicate.class})
    private Long adGroupId;// 广告组ID

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getAdIds() {
        return adIds;
    }

    public void setAdIds(List<Long> adIds) {
        this.adIds = adIds;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }
}
