package com.omni.ads.model.adscreativity;

import com.omni.ads.anno.AdRange;
import com.omni.ads.model.adsgroup.ValidationGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;


@ApiModel("广告创意批量修改状态请求对象")
public class AdsAdStatusForm implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告id列表", required = true)
    @NotEmpty(groups = {ValidationGroup.Status.class})
    private List<Long> adIds;

    @ApiParam(value = "标识暂停启动 0 启动 1 暂停", required = true)
    @NotNull(groups = {ValidationGroup.Status.class})
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Status.class})
    private Integer status2;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getAdIds() {
        return adIds;
    }

    public void setAdIds(List<Long> adIds) {
        this.adIds = adIds;
    }

    public Integer getStatus2() {
        return status2;
    }

    public void setStatus2(Integer status2) {
        this.status2 = status2;
    }
}
