package com.omni.ads.model.adscreativity;

import com.omni.ads.model.adsgroup.ValidationGroup;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author 80204975
 * @date 2018/6/13 21:30
 */

public class AdsAllAdListForm implements Serializable {
    private static final long serialVersionUID = 1L;

    private List<Long> adIds; // 广告id列表

//    private Long planId;// 计划ID

//    private Long adGroupId;// 广告组ID

    private Integer auditStatus;// 审核状态 0:未审核 1:审核通过 2:审核不通过

    private Integer deleteFlag; // 删除标识 0 未删除 1 删除

//    @AdRange(values = {0, 1, 2, 3, 4, 5}, groups = {ValidationGroup.Find.class})
//    private Integer showStatus; // 0 启动中1. 广告暂停中2. 应用异常状态3. 广告组暂停 4. 计划暂停中

    @NotNull
    @Min(value = 1, groups = {ValidationGroup.Find.class})
    private Integer page; // 第几页

    @NotNull
    @Min(value = 1, groups = {ValidationGroup.Find.class})
    private Integer pageCount; //每页数量

    private Integer startInsertTime;
    private Integer endInsertTime;
    private Integer startUpdateTime;
    private Integer endUpdateTime;

    /**
     * 广告版本： 2-2.0广告，3-3.0广告
     */
    private Integer adFlag;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getAdIds() {
        return adIds;
    }

    public void setAdIds(List<Long> adIds) {
        this.adIds = adIds;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageCount() {
        return pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Integer getStartInsertTime() {
        return startInsertTime;
    }

    public void setStartInsertTime(Integer startInsertTime) {
        this.startInsertTime = startInsertTime;
    }

    public Integer getEndInsertTime() {
        return endInsertTime;
    }

    public void setEndInsertTime(Integer endInsertTime) {
        this.endInsertTime = endInsertTime;
    }

    public Integer getStartUpdateTime() {
        return startUpdateTime;
    }

    public void setStartUpdateTime(Integer startUpdateTime) {
        this.startUpdateTime = startUpdateTime;
    }

    public Integer getEndUpdateTime() {
        return endUpdateTime;
    }

    public void setEndUpdateTime(Integer endUpdateTime) {
        this.endUpdateTime = endUpdateTime;
    }

    public Integer getAdFlag() {
        return adFlag;
    }

    public void setAdFlag(Integer adFlag) {
        this.adFlag = adFlag;
    }
}
