package com.omni.ads.model.adscreativity.vo;

import com.omni.ads.model.adsgroup.ValidationGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.util.List;

@ApiModel("广告请求对象")
public class AdsAdCollectReq implements Serializable {

    /****************************************
     * ************  基础信息 ***************
     ****************************************/

    @ApiParam(value = "广告ID[编辑时必填]", required = true)
    @Min(value = 20000, groups = {ValidationGroup.Edit.class})
    @Max(value = Integer.MAX_VALUE, groups = {Groups.Edit.class})
    private Long adId;

    @ApiParam(value = "广告名称[新增时必填]", required = true)
    @Size(min = 1, max = 100, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String adName;

    @ApiParam(value = "外部广告id", required = false, hidden = true)
    private String openAdId;

    @ApiParam(value = "广告状态(按位或)1:广告启停位(1:暂停;0:启用)", required = false)
    private Integer status;

    @ApiParam(value = "广告来源，1:oppo", required = false, hidden = true)
    private Integer adSource;

    @ApiParam(value = "统一规格ID[新增时必填]", required = true)
    private Integer globalSpecId;

    /****************************************
     * ************  计划广告组 **************
     ****************************************/

    @ApiParam(value = "计划ID[新增、编辑时必填]", required = true)
    @NotNull(groups = {ValidationGroup.Add.class})
    @Min(value = 1, groups = {ValidationGroup.Add.class})
    @Max(value = Integer.MAX_VALUE, groups = {ValidationGroup.Add.class})
    private Long adPlanId;

    @ApiParam(value = "广告组ID[新增、编辑时必填]", required = true)
    @NotNull(groups = {ValidationGroup.Add.class})
    @Min(value = 1, groups = {ValidationGroup.Add.class})
    @Max(value = Integer.MAX_VALUE, groups = {ValidationGroup.Add.class})
    private Long adGroupId;

    /****************************************
     * ************  创意相关 ***************
     ****************************************/

    @ApiParam(value = "广告文案", required = false)
    private String copywriter;

    @ApiParam(value = "广告描述", required = false)
    private String content;

    @ApiModelProperty(value = "文案id", required = false)
    @Deprecated
    private Long copywriterId;

    @ApiParam(value = "品牌名称", required = false)
    private String brandName;// 品牌名称

    @ApiParam(value = "按钮文案", required = false)
    private String buttonTxt;

    @ApiParam(value = "图片素材id", required = false)
    private List<Long> imgMatIds;

    @ApiParam(value = "视频素材id", required = false)
    private List<Long> videoMatIds;

    @ApiParam(value = " 互动素材id", required = false)
    private List<Long> interactMatIds;

    @ApiParam(value = "品牌LOGO图片id", required = false)
    private Long brandLogoImgId;

    @ApiParam(value = "视频结束背景图id", required = false)
    private Long videoBgImgId;

    @ApiParam(value = "视频封面图id", required = false)
    private Long videoImgId;

    @ApiParam(value = "是否衍生 0-否 1-是", required = false)
    private Integer dynamicCr;

    @ApiParam(value = "衍生指定模板", required = false)
    private String deriveTemplate;

    @ApiParam(value = "是否开启动态创意 0-否 1-是", required = false)
    private Integer interactCr;

    @ApiParam(value = "应用创意id", required = false)
    private Long appCreativeId;

    @ApiParam(value = "互动创意id", required = false)
    private Long creativityId;

    /**
     * 3.0新增 - 2-标识一键集成（模型继承） 5-程序化创意
     */
    private Integer vrType;

    /****************************************
     * ************  监测链接 ***************
     ****************************************/

    @ApiParam(value = "曝光监测链接", required = false)
    @Pattern(groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class},
            regexp = "(ftp|https)://(?:[\\w-\\.]{0,255}+)(?:(?:\\/?[^\\s]{0,255}){0,255}+)|(^$)")
    private String exposeUrl;

    @ApiParam(value = "曝光结束监测链接", required = false)
    @Pattern(groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class},
            regexp = "(ftp|https)://(?:[\\w-\\.]{0,255}+)(?:(?:\\/?[^\\s]{0,255}){0,255}+)|(^$)")
    private String exposeEndUrl;

    @ApiParam(value = "点击监测链接", required = false)
    @Pattern(groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class},
            regexp = "(ftp|https)://(?:[\\w-\\.]{0,255}+)(?:(?:\\/?[^\\s]{0,255}){0,255}+)|(^$)")
    private String clickUrl;

    @ApiParam(value = "开始播放监测链接", required = false)
    @Pattern(groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class},
            regexp = "(ftp|https)://(?:[\\w-\\.]{0,255}+)(?:(?:\\/?[^\\s]{0,255}){0,255}+)|(^$)")
    private String playBeginUrl;

    @Pattern(groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class},
            regexp = "(ftp|https)://(?:[\\w-\\.]{0,255}+)(?:(?:\\/?[^\\s]{0,255}){0,255}+)|(^$)")
    @ApiParam(value = "结束播放监测链接", required = false)
    private String playEndUrl;

    @Pattern(groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class},
            regexp = "(ftp|https)://(?:[\\w-\\.]{0,255}+)(?:(?:\\/?[^\\s]{0,255}){0,255}+)|(^$)")
    @ApiParam(value = "下载监测链接", required = false)
    private String downloadUrl;

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getOpenAdId() {
        return openAdId;
    }

    public void setOpenAdId(String openAdId) {
        this.openAdId = openAdId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getAdSource() {
        return adSource;
    }

    public void setAdSource(Integer adSource) {
        this.adSource = adSource;
    }

    public Integer getGlobalSpecId() {
        return globalSpecId;
    }

    public void setGlobalSpecId(Integer globalSpecId) {
        this.globalSpecId = globalSpecId;
    }

    public Long getAdPlanId() {
        return adPlanId;
    }

    public void setAdPlanId(Long adPlanId) {
        this.adPlanId = adPlanId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getCopywriter() {
        return copywriter;
    }

    public void setCopywriter(String copywriter) {
        this.copywriter = copywriter;
    }

    public Long getCopywriterId() {
        return copywriterId;
    }

    public void setCopywriterId(Long copywriterId) {
        this.copywriterId = copywriterId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt;
    }

    public List<Long> getImgMatIds() {
        return imgMatIds;
    }

    public void setImgMatIds(List<Long> imgMatIds) {
        this.imgMatIds = imgMatIds;
    }

    public List<Long> getVideoMatIds() {
        return videoMatIds;
    }

    public void setVideoMatIds(List<Long> videoMatIds) {
        this.videoMatIds = videoMatIds;
    }

    public List<Long> getInteractMatIds() {
        return interactMatIds;
    }

    public void setInteractMatIds(List<Long> interactMatIds) {
        this.interactMatIds = interactMatIds;
    }

    public Long getBrandLogoImgId() {
        return brandLogoImgId;
    }

    public void setBrandLogoImgId(Long brandLogoImgId) {
        this.brandLogoImgId = brandLogoImgId;
    }

    public Long getVideoBgImgId() {
        return videoBgImgId;
    }

    public void setVideoBgImgId(Long videoBgImgId) {
        this.videoBgImgId = videoBgImgId;
    }

    public Long getVideoImgId() {
        return videoImgId;
    }

    public void setVideoImgId(Long videoImgId) {
        this.videoImgId = videoImgId;
    }

    public Integer getDynamicCr() {
        return dynamicCr;
    }

    public void setDynamicCr(Integer dynamicCr) {
        this.dynamicCr = dynamicCr;
    }

    public Integer getInteractCr() {
        return interactCr;
    }

    public void setInteractCr(Integer interactCr) {
        this.interactCr = interactCr;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDeriveTemplate() {
        return deriveTemplate;
    }

    public void setDeriveTemplate(String deriveTemplate) {
        this.deriveTemplate = deriveTemplate;
    }

    public Long getAppCreativeId() {
        return appCreativeId;
    }

    public void setAppCreativeId(Long appCreativeId) {
        this.appCreativeId = appCreativeId;
    }

    public Long getCreativityId() {
        return creativityId;
    }

    public void setCreativityId(Long creativityId) {
        this.creativityId = creativityId;
    }

    public Integer getVrType() {
        return vrType;
    }

    public void setVrType(Integer vrType) {
        this.vrType = vrType;
    }

    public String getExposeUrl() {
        return exposeUrl;
    }

    public void setExposeUrl(String exposeUrl) {
        this.exposeUrl = exposeUrl;
    }

    public String getExposeEndUrl() {
        return exposeEndUrl;
    }

    public void setExposeEndUrl(String exposeEndUrl) {
        this.exposeEndUrl = exposeEndUrl;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public String getPlayBeginUrl() {
        return playBeginUrl;
    }

    public void setPlayBeginUrl(String playBeginUrl) {
        this.playBeginUrl = playBeginUrl;
    }

    public String getPlayEndUrl() {
        return playEndUrl;
    }

    public void setPlayEndUrl(String playEndUrl) {
        this.playEndUrl = playEndUrl;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}
