package com.omni.ads.model.adscreativity.vo;

import com.omni.ads.model.adsgroup.ValidationGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.io.Serializable;


@ApiModel("广告删除请求对象")
public class AdsAdDelReq implements Serializable {

    @ApiParam(value = "广告ID[删除时必填]", required = true)
    @Min(value = 20000, groups = {ValidationGroup.Edit.class})
    @Max(value = Integer.MAX_VALUE, groups = {Groups.Edit.class})
    private Long adId;

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }
}
