package com.omni.ads.model.adscreativity.vo;


import java.io.Serializable;
import java.util.List;


public class HttpPage<T> implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 页码
     */
    private int pageNum;
    /**
     * 每页大小
     */
    private int pageSize;
    /**
     * 数据总条数
     */
    private int total;
    /**
     * 总页数
     */
    private int totalPage;
    /**
     * 数据集合
     */
    private List<T> records;

    /**
     * 构造方法
     */
    public HttpPage() {

    }

    /**
     * 构造方法
     */
    public HttpPage(int pageNum, int pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    /**
     * 构造方法
     *
     * @param pageNum
     * @param pageSize
     * @param total
     * @param list
     */
    public HttpPage(int pageNum, int pageSize, int total, List<T> list) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.records = list;
        this.totalPage = total % this.pageSize == 0 ? total / this.pageSize : total / this.pageSize + 1;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public List<T> getRecords() {
        return records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }
}
