package com.omni.ads.model.adsgroup;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量删除广告组
 * 调用场景：广告组列表批量删除
 */

@ApiModel("广告组批量删除请求对象")
public class AdsBatchGroupDeleteForm implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiParam(value = "广告组id列表", required = true)
    @NotNull(groups = {ValidationGroup.Delete.class}, message = "groupIds参数不能为空")
    private List<Long> groupIds;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }
}
