package com.omni.ads.model.adsgroup;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量复制广告组
 * 调用场景：广告组列表批量复制
 * @author 80242259
 * @date 2021/6/10 20:00
 */
@ApiModel("广告组批量复制请求对象")
public class AdsBatchGroupReplicateForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告组id列表", required = true)
    @NotNull(groups = {ValidationGroup.BatchReplicate.class}, message = "groupIds参数不能为空")
    private List<Long> groupIds;

    @ApiParam(value = "计划id", required = true)
    @NotNull(groups = {ValidationGroup.BatchReplicate.class}, message = "planId参数不能为空")
    private Long planId;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
}
