package com.omni.ads.model.adsgroup;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量修改广告组排期
 * 调用场景：广告组列表批量修改排期
 * @author 80242259
 * @date 2021/6/10 20:04
 */
@ApiModel("广告组批量修改排期请求对象")
public class AdsBatchGroupScheduleForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告组id列表", required = true)
    @NotNull(groups = {ValidationGroup.Schedule.class}, message = "groupIds参数不能为空")
    private List<Long> groupIds;

    @ApiParam(value = "推广时段限制，0-不限制推广时段 1-限制推广时段，当为1时，timeSet必传", required = false)
    @NotNull(groups = {ValidationGroup.Schedule.class})
    @AdRange(values = {1, 0}, groups = {ValidationGroup.Schedule.class}, message = "timeLimit取值为0或1")
    private Integer timeLimit;

    @ApiParam(value = "推广时段，格式为json字符串，（x-(1-7)对应周一到周日）, 如timeSet=”{‘1’:‘1,2,3’}”表示周一的0:30-1:00,1:00-1:30，1:30-2:00为播放时间, 开始时间不能小于今天", required = false)
    private String timeSet;

    @ApiParam(value = "推广日期限制 0-不限制推广日期 1-限制推广日期，当为1时，beginTime和endTime必传", required = false)
    @NotNull(groups = {ValidationGroup.Schedule.class})
    @AdRange(values = {1, 0}, groups = {ValidationGroup.Schedule.class}, message = "dayLimit取值为0或1")
    private Integer dayLimit;

    @ApiParam(value = "推广开始时间，格式：YYYYMMDD", required = false)
    @Range(min = 10000000, max = 99999999, groups = {ValidationGroup.Schedule.class}, message = "beginTime时间格式错误")
    private Integer beginTime;

    @ApiParam(value = "推广截止时间，格式：YYYYMMDD", required = false)
    @Range(min = 10000000, max = 99999999, groups = {ValidationGroup.Schedule.class}, message = "endTime时间格式错误")
    private Integer endTime;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public Integer getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getTimeSet() {
        return timeSet;
    }

    public void setTimeSet(String timeSet) {
        this.timeSet = timeSet;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }

    public Integer getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    public Integer getEndTime() {
        return endTime;
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
    }
}
