package com.omni.ads.model.adsgroup;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量修改广告组状态
 * 调用场景：广告组列表批量修改状态
 * @author 80242259
 * @date 2021/6/10 19:47
 */
@ApiModel("广告组批量修改状态请求对象")
public class AdsBatchGroupStatusForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告组id列表", required = true)
    @NotNull(groups = {ValidationGroup.Status.class}, message = "groupIds参数不能为空")
    private List<Long> groupIds;

    @ApiParam(value = "开关状态 0 开启 1 关闭", required = true)
    @AdRange(values = {1, 0}, groups = {ValidationGroup.Status.class}, message = "status2取值为0或1")
    @NotNull(groups = ValidationGroup.Status.class, message = "status2不能为空")
    private Integer status2;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public Integer getStatus2() {
        return status2;
    }

    public void setStatus2(Integer status2) {
        this.status2 = status2;
    }
}
