package com.omni.ads.model.adsgroup;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author 80242259
 * @date 2021/6/10 20:02
 */
@ApiModel("广告组批量修改定向包请求对象")
public class AdsBatchGroupTargetForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告组id列表", required = true)
    @NotNull(groups = {ValidationGroup.BatchTarget.class}, message = "groupIds参数不能为空")
    private List<Long> groupIds;

    @ApiParam(value = "定向id", required = true)
    @NotNull(groups = ValidationGroup.BatchTarget.class, message = "targetId不能为空")
    @Min(value = 0, groups = {ValidationGroup.BatchTarget.class}, message = "targetId必须大于等于0")
    private Long targetId;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
}
