package com.omni.ads.model.adsgroup;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量修改广告组【基础出价】，营销平台3.0
 * 调用场景：广告组列表批量修改价格、广告组详情页修改基础出价
 * @author 80242259
 * @date 2021/6/10 11:32
 */
@ApiModel("广告组批量修改基础出价请求对象")
public class AdsBatchPriceForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告组id列表", required = true)
    @NotNull(groups = {ValidationGroup.BatchPrice.class}, message = "groupIds参数不能为空")
    private List<Long> groupIds;

    @ApiParam(value = "按百分比修改出价，例如：50")
    @Range(min = 0, max = 1000000, groups = {ValidationGroup.BatchPrice.class}, message = "percent取值范围为0~1000000")
    private Integer percent;      // percent与price两者必传其一

    @ApiParam(value = "基础出价（单位：分）")
    @Range(min = 0, max = 1000000, groups = {ValidationGroup.BatchPrice.class}, message = "price取值范围为0~1000000（分）")
    private Integer price;        // percent与price两者必传其一

    @ApiParam(value = "是否支持广告组出价 1-支持，要么不传，要么传1", required = false)
    @AdRange(values = {1}, groups = {ValidationGroup.BatchPrice.class}, message = "groupPrice取值只为1")
    private Integer groupPrice; // 修改price时需传入groupPrice

    @ApiParam(value = "计费方式.1:CPD 2:CPC 3:CPM 4:CPS 5:OCPC 6:CPA", required = false)
    @AdRange(values = {1, 2, 3, 4, 5, 6}, groups = {ValidationGroup.BatchPrice.class}, message = "billingType取值为1~6")
    private Integer billingType;   // 修改price时需传入billingType

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public Integer getPercent() {
        return percent;
    }

    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Integer getGroupPrice() {
        return groupPrice;
    }

    public void setGroupPrice(Integer groupPrice) {
        this.groupPrice = groupPrice;
    }

    public Integer getBillingType() {
        return billingType;
    }

    public void setBillingType(Integer billingType) {
        this.billingType = billingType;
    }
}
