package com.omni.ads.model.adsgroup;

import com.omni.ads.model.adsconfig.CommunalBaseDo;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
/**新建广告组返回信息*/
public class AdsCommunalGroupVo extends CommunalBaseDo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "广告组id")
    private Long adGroupId;

    @ApiModelProperty(value = "广告组名称")
    private String adGroupName;

    @ApiModelProperty(value = "计划id")
    private Long planId;

    @ApiModelProperty(value = "计划名称")
    private String planName;

    @ApiModelProperty(value = "标的物类型 1：链接推广 2：应用推广")
    private Integer targetType;

    @ApiModelProperty(value = "落地页id")
    private Long pageId;

    @ApiModelProperty(value = "落地页建站类型:1-一叶智能 2-云脑建站 3-达尔文 4-萤火虫建站 5-快应用建站 6-广告主自建页面 JS SDK 7-H5 API 回传 8-信息流线索直达")
    private Integer pageType;

    @ApiModelProperty(value = "目标链接")
    private String pageUrl;

    @ApiModelProperty(value = "直达链接")
    private String deepUrl;

    @ApiModelProperty(value = "应用id")
    private Long appId;

    @ApiModelProperty(value = "应用包名")
    private String appPackage;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "app推广渠道标识")
    private String appRef;

    @ApiModelProperty(value = "应用一级类目")
    private Integer categoryId;

    @ApiModelProperty(value = "应用二级类目")
    private Integer secondCategoryId;

    @ApiModelProperty(value = "应用三级类目")
    private Integer thirdCategroyId;

    @ApiModelProperty(value = "快应用链接")
    private String instantAppUrl;

    @ApiModelProperty(value = "快应用AppId")
    private Integer instantAppId;

    @ApiModelProperty(value = "推广开始时间 YYYYMMDD")
    private Integer beginTime;

    @ApiModelProperty(value = "推广截止时间")
    private Integer endTime;

    @ApiModelProperty(value = "定向id")
    private Long targetId;

    @ApiModelProperty(value = "定向来源：1-广告组私有定向 2-可复用定向")
    private Integer targetSource;

    @ApiModelProperty(value = "推广时段")
    private String timeSet;

    @ApiModelProperty(value = "广告组状态")
    private Integer status;

    @ApiModelProperty(value = "推广目的")
    private Integer extensionType;

    @ApiModelProperty(value = "推广流量")
    private Integer extensionFlow;

    @ApiModelProperty(value = "流量场景")
    private Integer flowScene;

    @ApiModelProperty(value = "播放时段限制 0 不限 1 限制")
    private Integer timeLimit;

    @ApiModelProperty(value = "播放日期限制 0 不限 1 限制")
    private Integer dayLimit;

    @ApiModelProperty(value = "开关状态 0 开启 1 关闭")
    private Integer status2;

    @ApiModelProperty(value = "openGroupId")
    private String openGroupId;

    @ApiModelProperty(value = "智能扩量-信息流 扩量标示位 0：未扩量 1：广告扩量 2：广告组拓量")
    private Integer smartExpandType;

    @ApiModelProperty(value = "下载并打开")
    private Integer autoOpenFlag;

    @ApiModelProperty(value = "出价、计费: 0 不支持, 1 支持")
    private Integer groupPrice;

    @ApiModelProperty(value = "计费方式.1:CPD 2:CPC 3:CPM 4:CPS")
    private Integer billingType;

    @ApiModelProperty(value = "基础出价（单位：分）")
    private Integer price;

    @ApiModelProperty(value = "目标转化出价")
    private Integer ocpcPrice;

    @ApiModelProperty(value = "目标转化类型:1-下载,2-拉活")
    private Integer ocpcType;

    @ApiModelProperty(value = "区分ocpc单出价和双出价. 默认0-单出价，1-双出价")
    private Integer ocpcOptmType;

    @ApiModelProperty(value = "深度ocpc转化出价")
    private Integer deepOcpcPrice;

    @ApiModelProperty(value = "深度ocpc转换类型， see @AdOcpcTypeEnum. ocpcState都用一个")
    private Integer deepOcpcType;

    @ApiModelProperty(value = "ocpc转化阶段.1-点击阶段.2-转化阶段.3-深度转化阶段")
    private Integer ocpcState;

    @ApiModelProperty(value = "目标ROI系数 * 1000000, (0,10]")
    private Integer targetROI;

    @ApiModelProperty(value = "投放模式 0-普通投放 1-跟随投放")
    private Integer adServingType;

    @ApiModelProperty(value = "更随最高价格")
    private Integer followMaxPrice;

    @ApiModelProperty(value = "开启免一阶标识 0-未开启 1-开启")
    private Integer defaultSecondStage;

    @ApiModelProperty(value = "跟随appId列表")
    private List<Long> followAppIdList;

    @ApiModelProperty(value = "智能拓量")
    private String smartExpandBreakthrough;

    @ApiModelProperty(value = "是否为动态出价 1-开启动态出价，0-关闭动态出价，2-不使用动态出价，默认值为2 不使用动态出价")
    private Integer dynamicPrice;

    @ApiModelProperty(value = "是否打开快应用加桌 1-开启加桌，0-关闭加桌，默认值为0")
    private Integer linkDeskFlag;

    @ApiModelProperty(value = "一键继承源广告组id，大于0标识启用一键继承")
    private Long inheritGroupId;

    @ApiModelProperty(value = "一键起量状态，0表示未起量，1表示起量中，2表示起量结束")
    private Integer gainQuantityStatus;

    @ApiModelProperty(value = "一键起量状态名称，0表示未起量，1表示起量中，2表示起量结束")
    private String gainQuantityStatusName;

    @ApiModelProperty(value = "一键起量预算，单位是分")
    private Integer gainQuantityBudget;

    @ApiModelProperty(value = "一键起量次数，针对每个广告组，每次起量后累加")
    private Integer gainQuantityCycles;

    @ApiModelProperty(value = "一键起量日期，当且仅当等于当日才能起量")
    private Integer gainQuantityDate;

    @ApiModelProperty(value = "一键起量开关，0表示未开启，1表示开启")
    private Integer gainQuantitySwitch;

    @ApiModelProperty(value = "OCPX自动赔付状态")
    private Integer ocpxCompensateStatus;

    @ApiModelProperty(value = "OCPX自动优化开关，0表示未开启，1表示开启")
    private Integer ocpxOptimizeSwitch;

    @ApiModelProperty(value = "OCPX优化类型")
    private Integer ocpxOptimizeType;

    @ApiModelProperty(value = "OCPX自动赔付状态描述")
    private String ocpxCompensateStatusName;

    @ApiModelProperty(value = "OCPX自动赔付金额(分)")
    private Integer ocpxCompensateAmount;

    @ApiModelProperty(value = "OCPX自动赔付失效原因")
    private String ocpxCompensateMsg;

    @ApiModelProperty(value = "渠道包ID")
    private Long channelPkgId;

    private Integer appletType;

    private String weChatGameId;

    private String weChatGameUrl;

    @ApiModelProperty(value = "程序化类型【0-非程序化(默认),5-程序化創意】")
    private Integer programmaticType;

    @ApiModelProperty(value = "广告类型，0-普通广告，1-预约广告")
    private Integer advertiseType;

    @ApiModelProperty(value = "广告组扩展信息map, key-type, value-值")
    private String extJson;

    @ApiModelProperty(value = "实验状态【0-当前无实验,1-当前有实验】")
    private Integer expStatus = 0;

    @ApiModelProperty(value = "push应用内页类型")
    private Integer pushAppPageType;

    public Integer getDefaultSecondStage() {
        return defaultSecondStage;
    }

    public void setDefaultSecondStage(Integer defaultSecondStage) {
        this.defaultSecondStage = defaultSecondStage;
    }

    public Integer getLinkDeskFlag() {
        return linkDeskFlag;
    }

    public void setLinkDeskFlag(Integer linkDeskFlag) {
        this.linkDeskFlag = linkDeskFlag;
    }

    public Long getInheritGroupId() {
        return inheritGroupId;
    }

    public void setInheritGroupId(Long inheritGroupId) {
        this.inheritGroupId = inheritGroupId;
    }

    public Integer getGainQuantityStatus() {
        return gainQuantityStatus;
    }

    public void setGainQuantityStatus(Integer gainQuantityStatus) {
        this.gainQuantityStatus = gainQuantityStatus;
    }

    public String getGainQuantityStatusName() {
        return gainQuantityStatusName;
    }

    public void setGainQuantityStatusName(String gainQuantityStatusName) {
        this.gainQuantityStatusName = gainQuantityStatusName;
    }

    public Integer getGainQuantityBudget() {
        return gainQuantityBudget;
    }

    public void setGainQuantityBudget(Integer gainQuantityBudget) {
        this.gainQuantityBudget = gainQuantityBudget;
    }

    public Integer getGainQuantityCycles() {
        return gainQuantityCycles;
    }

    public void setGainQuantityCycles(Integer gainQuantityCycles) {
        this.gainQuantityCycles = gainQuantityCycles;
    }

    public Integer getGainQuantityDate() {
        return gainQuantityDate;
    }

    public void setGainQuantityDate(Integer gainQuantityDate) {
        this.gainQuantityDate = gainQuantityDate;
    }

    public Integer getGainQuantitySwitch() {
        return gainQuantitySwitch;
    }

    public void setGainQuantitySwitch(Integer gainQuantitySwitch) {
        this.gainQuantitySwitch = gainQuantitySwitch;
    }

    public Integer getOcpxCompensateStatus() {
        return ocpxCompensateStatus;
    }

    public void setOcpxCompensateStatus(Integer ocpxCompensateStatus) {
        this.ocpxCompensateStatus = ocpxCompensateStatus;
    }

    public Integer getOcpxOptimizeSwitch() {
        return ocpxOptimizeSwitch;
    }

    public void setOcpxOptimizeSwitch(Integer ocpxOptimizeSwitch) {
        this.ocpxOptimizeSwitch = ocpxOptimizeSwitch;
    }

    public Integer getOcpxOptimizeType() {
        return ocpxOptimizeType;
    }

    public void setOcpxOptimizeType(Integer ocpxOptimizeType) {
        this.ocpxOptimizeType = ocpxOptimizeType;
    }

    public String getOcpxCompensateStatusName() {
        return ocpxCompensateStatusName;
    }

    public void setOcpxCompensateStatusName(String ocpxCompensateStatusName) {
        this.ocpxCompensateStatusName = ocpxCompensateStatusName;
    }

    public Integer getOcpxCompensateAmount() {
        return ocpxCompensateAmount;
    }

    public void setOcpxCompensateAmount(Integer ocpxCompensateAmount) {
        this.ocpxCompensateAmount = ocpxCompensateAmount;
    }

    public String getOcpxCompensateMsg() {
        return ocpxCompensateMsg;
    }

    public void setOcpxCompensateMsg(String ocpxCompensateMsg) {
        this.ocpxCompensateMsg = ocpxCompensateMsg;
    }

    public Long getChannelPkgId() {
        return channelPkgId;
    }

    public void setChannelPkgId(Long channelPkgId) {
        this.channelPkgId = channelPkgId;
    }

    public Integer getAppletType() {
        return appletType;
    }

    public void setAppletType(Integer appletType) {
        this.appletType = appletType;
    }

    public String getWeChatGameId() {
        return weChatGameId;
    }

    public void setWeChatGameId(String weChatGameId) {
        this.weChatGameId = weChatGameId;
    }

    public String getWeChatGameUrl() {
        return weChatGameUrl;
    }

    public void setWeChatGameUrl(String weChatGameUrl) {
        this.weChatGameUrl = weChatGameUrl;
    }

    public Integer getProgrammaticType() {
        return programmaticType;
    }

    public void setProgrammaticType(Integer programmaticType) {
        this.programmaticType = programmaticType;
    }

    public Integer getAdvertiseType() {
        return advertiseType;
    }

    public void setAdvertiseType(Integer advertiseType) {
        this.advertiseType = advertiseType;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }

    public Integer getExpStatus() {
        return expStatus;
    }

    public void setExpStatus(Integer expStatus) {
        this.expStatus = expStatus;
    }

    public Integer getPushAppPageType() {
        return pushAppPageType;
    }

    public void setPushAppPageType(Integer pushAppPageType) {
        this.pushAppPageType = pushAppPageType;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Integer getTargetType() {
        return targetType;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getPageUrl() {
        return pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getDeepUrl() {
        return deepUrl;
    }

    public void setDeepUrl(String deepUrl) {
        this.deepUrl = deepUrl;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppRef() {
        return appRef;
    }

    public void setAppRef(String appRef) {
        this.appRef = appRef;
    }

    public Integer getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public Integer getSecondCategoryId() {
        return secondCategoryId;
    }

    public void setSecondCategoryId(Integer secondCategoryId) {
        this.secondCategoryId = secondCategoryId;
    }

    public Integer getThirdCategroyId() {
        return thirdCategroyId;
    }

    public void setThirdCategroyId(Integer thirdCategroyId) {
        this.thirdCategroyId = thirdCategroyId;
    }

    public String getInstantAppUrl() {
        return instantAppUrl;
    }

    public void setInstantAppUrl(String instantAppUrl) {
        this.instantAppUrl = instantAppUrl;
    }

    public Integer getInstantAppId() {
        return instantAppId;
    }

    public void setInstantAppId(Integer instantAppId) {
        this.instantAppId = instantAppId;
    }

    public Integer getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    public Integer getEndTime() {
        return endTime;
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public Integer getTargetSource() {
        return targetSource;
    }

    public void setTargetSource(Integer targetSource) {
        this.targetSource = targetSource;
    }

    public String getTimeSet() {
        return timeSet;
    }

    public void setTimeSet(String timeSet) {
        this.timeSet = timeSet;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Integer getExtensionFlow() {
        return extensionFlow;
    }

    public void setExtensionFlow(Integer extensionFlow) {
        this.extensionFlow = extensionFlow;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }

    public Integer getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }

    public Integer getStatus2() {
        return status2;
    }

    public void setStatus2(Integer status2) {
        this.status2 = status2;
    }

    public String getOpenGroupId() {
        return openGroupId;
    }

    public void setOpenGroupId(String openGroupId) {
        this.openGroupId = openGroupId;
    }

    public Integer getSmartExpandType() {
        return smartExpandType;
    }

    public void setSmartExpandType(Integer smartExpandType) {
        this.smartExpandType = smartExpandType;
    }

    public Integer getAutoOpenFlag() {
        return autoOpenFlag;
    }

    public void setAutoOpenFlag(Integer autoOpenFlag) {
        this.autoOpenFlag = autoOpenFlag;
    }

    public Integer getGroupPrice() {
        return groupPrice;
    }

    public void setGroupPrice(Integer groupPrice) {
        this.groupPrice = groupPrice;
    }

    public Integer getBillingType() {
        return billingType;
    }

    public void setBillingType(Integer billingType) {
        this.billingType = billingType;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Integer getOcpcPrice() {
        return ocpcPrice;
    }

    public void setOcpcPrice(Integer ocpcPrice) {
        this.ocpcPrice = ocpcPrice;
    }

    public Integer getOcpcType() {
        return ocpcType;
    }

    public void setOcpcType(Integer ocpcType) {
        this.ocpcType = ocpcType;
    }

    public Integer getOcpcOptmType() {
        return ocpcOptmType;
    }

    public void setOcpcOptmType(Integer ocpcOptmType) {
        this.ocpcOptmType = ocpcOptmType;
    }

    public Integer getDeepOcpcPrice() {
        return deepOcpcPrice;
    }

    public void setDeepOcpcPrice(Integer deepOcpcPrice) {
        this.deepOcpcPrice = deepOcpcPrice;
    }

    public Integer getDeepOcpcType() {
        return deepOcpcType;
    }

    public void setDeepOcpcType(Integer deepOcpcType) {
        this.deepOcpcType = deepOcpcType;
    }

    public Integer getOcpcState() {
        return ocpcState;
    }

    public void setOcpcState(Integer ocpcState) {
        this.ocpcState = ocpcState;
    }

    public Integer getTargetROI() {
        return targetROI;
    }

    public void setTargetROI(Integer targetROI) {
        this.targetROI = targetROI;
    }

    public Integer getAdServingType() {
        return adServingType;
    }

    public void setAdServingType(Integer adServingType) {
        this.adServingType = adServingType;
    }

    public Integer getFollowMaxPrice() {
        return followMaxPrice;
    }

    public void setFollowMaxPrice(Integer followMaxPrice) {
        this.followMaxPrice = followMaxPrice;
    }

    public List<Long> getFollowAppIdList() {
        return followAppIdList;
    }

    public void setFollowAppIdList(List<Long> followAppIdList) {
        this.followAppIdList = followAppIdList;
    }

    public String getSmartExpandBreakthrough() {
        return smartExpandBreakthrough;
    }

    public void setSmartExpandBreakthrough(String smartExpandBreakthrough) {
        this.smartExpandBreakthrough = smartExpandBreakthrough;
    }

    public Integer getDynamicPrice() {
        return dynamicPrice;
    }

    public void setDynamicPrice(Integer dynamicPrice) {
        this.dynamicPrice = dynamicPrice;
    }
}
