package com.omni.ads.model.adsgroup;

import com.omni.ads.anno.AdRange;
import com.omni.ads.model.adsconfig.AdSearchPremiumKwSaveDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@ApiModel("广告组编辑接口请求对象")
public class AdsGroupEditForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "计划id", required = true)
    @NotNull(groups = {ValidationGroup.Edit.class}, message = "planId不能为空")
    private Long planId;

    @ApiParam(value = "广告组id", required = true)
    @NotNull(groups = {ValidationGroup.Edit.class}, message = "adGroupId不能为空")
    private Long adGroupId;

    @ApiParam(value = "广告组名称，长度限制为1~100个字符", required = false)
    @Length(min = 1, max = 100, groups = {ValidationGroup.Edit.class}, message = "adGroupName长度限制为1~100个字符")
    private String adGroupName;

    @ApiParam(value = "应用id", required = false)
    private Long appId;

    @ApiParam(value = "落地页id。若为萤火虫应用下载模板页，则传递模板id，可通/v3/communal/h5Template/list接口获取模板id和url，也可参考《典型场景举例-新建应用下载模板页广告组》", required = false)
    private Long pageId;

    @ApiParam(value = "落地页建站类型: 0：自定义落地页 1：一叶智能 2：云脑建站 3：达尔文建站 4：萤火虫建站 5：快应用建站 6：广告主自建页面 JS SDK " +
            "7：H5 API 回传 8：信息流线索直达 9：商店详情页 11：萤火虫应用模板下载页 12：互动落地页", required = false)
    private Integer pageType;

    @ApiParam(value = "广告h5落地链接（链接,应用,快应用推广同样作用）选择下载浮层或者F版的落地链接类型，需要将当前广告的目标落地链接URLencode之后，组装在下载浮层的URL地址后面，链接推广、快应用推广时必填。若为萤火虫应用下载模板页，则传递模板url，可通/v3/communal/h5Template/list接口获取模板id和url，也可参考《典型场景举例-新建应用下载模板页广告组》", required = false)
    private String pageUrl;

    @ApiParam(value = "直达链接", required = false)
    @Length(min = 0, max = 1000, groups = {ValidationGroup.Edit.class}, message = "直达链接长度限制为0~1000个字符")
    private String deepUrl;

    @ApiParam(value = "快应用Id", required = false)
    private Integer instantAppId;

    @ApiParam(value = "快应用落地链接", required = false)
    @Length(max = 1024, groups = {ValidationGroup.Edit.class}, message = "快应用落地链接长度限制为1024个字符")
    private String instantAppUrl;

    @ApiParam(value = "小程序类型")
    @Min(value = 0, groups = {ValidationGroup.Edit.class}, message = "appletType必须大于等于0")
    private Integer appletType;    // 小程序类型

    @Length(max = 50, groups = {ValidationGroup.Edit.class}, message = "小程序id长度限制为0~50个字符")
    private String appletId;         // 小程序ID

    @Length(max = 500, groups = {ValidationGroup.Edit.class}, message = "小程序Path长度限制为0~500个字符")
    private String appletPath;      // 小程序Path

    @ApiParam(value = "定向id", required = false)
    @Min(value = 0, groups = {ValidationGroup.Edit.class}, message = "targetId必须大于等于0")
    private Long targetId;

    @ApiParam(value = "定向来源：1-广告组私有定向 2-可复用定向", required = false)
//    @Min(value = 1, groups = {ValidationGroup.Edit.class}, message = "targetSource必须大于等于1")
    private Integer targetSource;

    @ApiParam(value = "标的物类型 1：链接推广 2：应用推广 3: 快应用推广 7: 小程序推广", required = false)
    private Integer extensionType;

    @ApiParam(value = "推广流量：1-全流量场景，2-自有流量，3-联盟流量", required = false)
    @AdRange(values = {1, 2, 3}, groups = {ValidationGroup.Edit.class}, message = "extensionFlow取值范围为1、2、3")
    private Integer extensionFlow;

    @ApiParam(value = "流量场景：1-全流量场景，2-精选推荐，3-安装有礼，4-开机必备，5-搜索，6-信息流，7-Banner，8-开屏，9-插屏，10-原生，11-激励视频，12-联盟通投。修改出价，流量场景不能为空", required = false)
    @AdRange(values = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, groups = {ValidationGroup.Edit.class}, message = "flowScene取值范围为1~13")
    private Integer flowScene;

    @ApiParam(value = "推广日期限制 0-不限制推广日期 1-限制推广日期，当为1时，beginTime和endTime必传", required = false)
    @AdRange(values = {1, 0}, groups = {ValidationGroup.Edit.class}, message = "dayLimit取值为0或1")
    private Integer dayLimit;

    @ApiParam(value = "推广开始时间，格式：YYYYMMDD", required = false)
    @Range(min = 10000000, max = 99999999, groups = {ValidationGroup.Edit.class}, message = "beginTime时间格式错误")
    private Integer beginTime;

    @ApiParam(value = "推广截止时间，格式：YYYYMMDD", required = false)
    @Range(min = 10000000, max = 99999999, groups = {ValidationGroup.Edit.class}, message = "endTime时间格式错误")
    private Integer endTime;

    @ApiParam(value = "推广时段，格式为json字符串，（x-(1-7)对应周一到周日）, 如timeSet=”{‘1’:‘1,2,3’}”表示周一的0:30-1:00,1:00-1:30，1:30-2:00为播放时间, 开始时间不能小于今天", required = false)
    private String timeSet;

    @ApiParam(value = "推广时段限制，0-不限制推广时段 1-限制推广时段，当为1时，timeSet必传", required = false)
    @AdRange(values = {1, 0}, groups = {ValidationGroup.Edit.class}, message = "timeLimit取值为0或1")
    private Integer timeLimit;

    @ApiParam(value = "是否支持广告组出价 1-支持，要么不传，要么传1，修改出价信息、落地页信息时groupPrice必填", required = false)
    @AdRange(values = {1}, groups = {ValidationGroup.Edit.class}, message = "groupPrice取值只为1")
    private Integer groupPrice;

    @ApiParam(value = "计费方式.1:CPD 2:CPC 3:CPM 4:CPS 5:OCPC 6:CPA", required = false)
    @AdRange(values = {1, 2, 3, 4, 5, 6}, groups = {ValidationGroup.Edit.class}, message = "billingType取值为1~6")
    private Integer billingType;

    @ApiParam(value = "基础出价（单位：分）", required = false)
    @Range(min = 0, max = 1000000, groups = {ValidationGroup.Edit.class}, message = "price取值范围为0~1000000（分）")
    private Integer price;

    @ApiParam(value = "目标转化出价（单位：分）", required = false)
    @Range(min = 0, max = 1000000, groups = {ValidationGroup.Edit.class}, message = "ocpcPrice取值范围为0~1000000（分）")
    private Integer ocpcPrice;

    @ApiParam(value = "目标转化类型，0-默认, 1-下载, 2-激活, 4-游戏注册, 5-游戏付费, 6-表单注册, 7-注册, 8-回传激活, " +
            "9-应用付费, 10-回传留存, 11-应用内自定义转化, 12-应用内授信, 13-应用内下单, 14-deepLink拉活, 15-系统留存, 16-deeplink回传激活, " +
            "17-deeplink回传注册, 18-deeplink应用付费, 19-deeplink应用内自定义转化, 20-deeplink应用内授信, 21-deeplink应用内下单, " +
            "22-快应用付费, 23-游戏付费ROI1", required = false)
    private Integer ocpcType;

    @ApiParam(value = "区分ocpc出价类型. 默认为0，0-单出价，1-双出价，2-两阶段", required = false)
    @AdRange(values = {1, 0, 2}, groups = {ValidationGroup.Edit.class}, message = "ocpcOptmType取值为0、1、2")
    private Integer ocpcOptmType;

    @ApiParam(value = "深度ocpc转化出价（单位：分）", required = false)
    @Range(min = 0, max = 1000000, groups = {ValidationGroup.Edit.class}, message = "deepOcpcPrice取值范围为0~1000000（分）")
    private Integer deepOcpcPrice;

    @ApiParam(value = "深度ocpc转换类型， 0-默认, 1-下载, 2-激活, 4-游戏注册, 5-游戏付费, 6-表单注册, 7-注册, 8-回传激活, " +
            "9-应用付费, 10-回传留存, 11-应用内自定义转化, 12-应用内授信, 13-应用内下单, 14-deepLink拉活, 15-系统留存, 16-deeplink回传激活, " +
            "17-deeplink回传注册, 18-deeplink应用付费, 19-deeplink应用内自定义转化, 20-deeplink应用内授信, 21-deeplink应用内下单, " +
            "22-快应用付费, 23-游戏付费ROI1", required = false)
    private Integer deepOcpcType;

    @ApiParam(value = "智能扩量-信息流 扩量标示位 0-未扩量 1-广告扩量 2-广告组拓量", required = false)
    @AdRange(values = {0, 1, 2}, groups = {ValidationGroup.Edit.class}, message = "deepOcpcType取值为范围为0~2")
    private Integer smartExpandType;

    @ApiParam(value = "下载并打开", required = false)
    private Integer autoOpenFlag;

    @ApiParam(value = "搜索关键词列表", required = false)
    private List<AdSearchPremiumKwSaveDTO> adSearchPremiumKwSaveDTOList;

    @ApiParam(value = "关键词（词包）转化出价（单位：分）")
    private Integer kwOcpcPrice;

    @ApiParam(value = "关键词（词包）深度转化出价（单位：分）")
    private Integer kwDeepOcpcPrice;

    @ApiParam(value = "目标ROI系数 * 1000000", required = false)
    @Range(min = 0, max = 10000000, groups = {ValidationGroup.Edit.class}, message = "targetROI取值范围为0~10000000")
    private Integer kwTargetROI;

    @ApiParam(value = "目标ROI系数 * 1000000", required = false)
    @Range(min = 0, max = 10000000, groups = {ValidationGroup.Edit.class}, message = "targetROI取值范围为0~10000000")
    private Integer targetROI;

    @ApiParam(value = "广告投放类型 0-普通投放 1-跟随投放", required = false, hidden = true)
    private Integer adServingType;

    @ApiParam(value = "跟随最高出价", required = false, hidden = true)
    private Integer followMaxPrice;

    @ApiParam(value = "跟随应用列表", required = false, hidden = true)
    private List<Long> followAppIdList;

    @ApiParam(value = "智能拓量", required = false)
    private String smartExpandBreakthrough;

    @ApiParam(value = "是否为动态出价 1-开启动态出价，0-关闭动态出价，2-不使用动态出价，默认值为2 不使用动态出价")
    @AdRange(values = {0, 1, 2}, groups = {ValidationGroup.Edit.class}, message = "dynamicPrice取值为0、1或2")
    private Integer dynamicPrice;

    @ApiParam(value = "是否开启免一阶 1-开启，0-关闭")
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Edit.class}, message = "defaultSecondStage取值为0、1")
    private Integer defaultSecondStage;

    @ApiParam(value = "是否打开快应用加桌 1-开启加桌，0-关闭加桌，默认值为0")
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Edit.class}, message = "linkDeskFlag取值为0、1")
    private Integer linkDeskFlag = 0;

    @ApiParam(value = "起量开关，0表示未开启，1表示开启")
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Edit.class}, message = "起量开关，0表示未开启，1表示开启")
    private Integer gainQuantitySwitch;

    @ApiParam(value = "起量预算，单位是分")
    @Range(min = 0, max = Integer.MAX_VALUE, groups = {ValidationGroup.Edit.class}, message = "起量预算，单位是分")
    private Integer gainQuantityBudget;

    @ApiParam(value = "OCPX自动优化开关，0表示未开启，1表示开启")
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Edit.class}, message = "OCPX自动优化开关，0表示未开启，1表示开启")
    private Integer ocpxOptimizeSwitch;

    @ApiParam(value = "OCPX优化类型")
    @Range(min = 0, max = Integer.MAX_VALUE, groups = {ValidationGroup.Edit.class}, message = "OCPX优化类型")
    private Integer ocpxOptimizeType;

    @ApiParam(value = "渠道包ID")
    @Range(min = 0, max = Integer.MAX_VALUE, groups = {ValidationGroup.Edit.class}, message = "渠道包ID非法")
    private Long channelPkgId;

    @ApiParam(value = "是否立即刷新ES数据", hidden = true)
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Edit.class}, message = "是否立即刷新ES数据，0表示不刷新，1表示刷新")
    private Integer immediatelyRefresh;

    @ApiParam(value = "广告类型,0-普通广告，1-预约广告")
    @AdRange(values = {0, 1}, groups = {ValidationGroup.Edit.class}, message = "广告类型非法")
    private Integer advertiseType;

    @ApiParam(value = "扩展字段,type-value形式存储广告组扩展信息")
    private String extJson;

    @ApiParam(value = "push应用内页类型")
    private Integer pushAppPageType;

    public Integer getPushAppPageType() {
        return pushAppPageType;
    }

    public void setPushAppPageType(Integer pushAppPageType) {
        this.pushAppPageType = pushAppPageType;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getPageUrl() {
        return pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getDeepUrl() {
        return deepUrl;
    }

    public void setDeepUrl(String deepUrl) {
        this.deepUrl = deepUrl;
    }

    public Integer getInstantAppId() {
        return instantAppId;
    }

    public void setInstantAppId(Integer instantAppId) {
        this.instantAppId = instantAppId;
    }

    public String getInstantAppUrl() {
        return instantAppUrl;
    }

    public void setInstantAppUrl(String instantAppUrl) {
        this.instantAppUrl = instantAppUrl;
    }

    public Integer getAppletType() {
        return appletType;
    }

    public void setAppletType(Integer appletType) {
        this.appletType = appletType;
    }

    public String getAppletId() {
        return appletId;
    }

    public void setAppletId(String appletId) {
        this.appletId = appletId;
    }

    public String getAppletPath() {
        return appletPath;
    }

    public void setAppletPath(String appletPath) {
        this.appletPath = appletPath;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public Integer getTargetSource() {
        return targetSource;
    }

    public void setTargetSource(Integer targetSource) {
        this.targetSource = targetSource;
    }

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Integer getExtensionFlow() {
        return extensionFlow;
    }

    public void setExtensionFlow(Integer extensionFlow) {
        this.extensionFlow = extensionFlow;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }

    public Integer getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    public Integer getEndTime() {
        return endTime;
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
    }

    public String getTimeSet() {
        return timeSet;
    }

    public void setTimeSet(String timeSet) {
        this.timeSet = timeSet;
    }

    public Integer getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Integer getGroupPrice() {
        return groupPrice;
    }

    public void setGroupPrice(Integer groupPrice) {
        this.groupPrice = groupPrice;
    }

    public Integer getBillingType() {
        return billingType;
    }

    public void setBillingType(Integer billingType) {
        this.billingType = billingType;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Integer getOcpcPrice() {
        return ocpcPrice;
    }

    public void setOcpcPrice(Integer ocpcPrice) {
        this.ocpcPrice = ocpcPrice;
    }

    public Integer getOcpcType() {
        return ocpcType;
    }

    public void setOcpcType(Integer ocpcType) {
        this.ocpcType = ocpcType;
    }

    public Integer getOcpcOptmType() {
        return ocpcOptmType;
    }

    public void setOcpcOptmType(Integer ocpcOptmType) {
        this.ocpcOptmType = ocpcOptmType;
    }

    public Integer getDeepOcpcPrice() {
        return deepOcpcPrice;
    }

    public void setDeepOcpcPrice(Integer deepOcpcPrice) {
        this.deepOcpcPrice = deepOcpcPrice;
    }

    public Integer getDeepOcpcType() {
        return deepOcpcType;
    }

    public void setDeepOcpcType(Integer deepOcpcType) {
        this.deepOcpcType = deepOcpcType;
    }

    public Integer getSmartExpandType() {
        return smartExpandType;
    }

    public void setSmartExpandType(Integer smartExpandType) {
        this.smartExpandType = smartExpandType;
    }

    public Integer getAutoOpenFlag() {
        return autoOpenFlag;
    }

    public void setAutoOpenFlag(Integer autoOpenFlag) {
        this.autoOpenFlag = autoOpenFlag;
    }

    public List<AdSearchPremiumKwSaveDTO> getAdSearchPremiumKwSaveDTOList() {
        return adSearchPremiumKwSaveDTOList;
    }

    public void setAdSearchPremiumKwSaveDTOList(List<AdSearchPremiumKwSaveDTO> adSearchPremiumKwSaveDTOList) {
        this.adSearchPremiumKwSaveDTOList = adSearchPremiumKwSaveDTOList;
    }

    public Integer getKwOcpcPrice() {
        return kwOcpcPrice;
    }

    public void setKwOcpcPrice(Integer kwOcpcPrice) {
        this.kwOcpcPrice = kwOcpcPrice;
    }

    public Integer getKwDeepOcpcPrice() {
        return kwDeepOcpcPrice;
    }

    public void setKwDeepOcpcPrice(Integer kwDeepOcpcPrice) {
        this.kwDeepOcpcPrice = kwDeepOcpcPrice;
    }

    public Integer getKwTargetROI() {
        return kwTargetROI;
    }

    public void setKwTargetROI(Integer kwTargetROI) {
        this.kwTargetROI = kwTargetROI;
    }

    public Integer getTargetROI() {
        return targetROI;
    }

    public void setTargetROI(Integer targetROI) {
        this.targetROI = targetROI;
    }

    public Integer getAdServingType() {
        return adServingType;
    }

    public void setAdServingType(Integer adServingType) {
        this.adServingType = adServingType;
    }

    public Integer getFollowMaxPrice() {
        return followMaxPrice;
    }

    public void setFollowMaxPrice(Integer followMaxPrice) {
        this.followMaxPrice = followMaxPrice;
    }

    public List<Long> getFollowAppIdList() {
        return followAppIdList;
    }

    public void setFollowAppIdList(List<Long> followAppIdList) {
        this.followAppIdList = followAppIdList;
    }

    public String getSmartExpandBreakthrough() {
        return smartExpandBreakthrough;
    }

    public void setSmartExpandBreakthrough(String smartExpandBreakthrough) {
        this.smartExpandBreakthrough = smartExpandBreakthrough;
    }

    public Integer getDynamicPrice() {
        return dynamicPrice;
    }

    public void setDynamicPrice(Integer dynamicPrice) {
        this.dynamicPrice = dynamicPrice;
    }

    public Integer getDefaultSecondStage() {
        return defaultSecondStage;
    }

    public void setDefaultSecondStage(Integer defaultSecondStage) {
        this.defaultSecondStage = defaultSecondStage;
    }

    public Integer getLinkDeskFlag() {
        return linkDeskFlag;
    }

    public void setLinkDeskFlag(Integer linkDeskFlag) {
        this.linkDeskFlag = linkDeskFlag;
    }

    public Integer getGainQuantitySwitch() {
        return gainQuantitySwitch;
    }

    public void setGainQuantitySwitch(Integer gainQuantitySwitch) {
        this.gainQuantitySwitch = gainQuantitySwitch;
    }

    public Integer getGainQuantityBudget() {
        return gainQuantityBudget;
    }

    public void setGainQuantityBudget(Integer gainQuantityBudget) {
        this.gainQuantityBudget = gainQuantityBudget;
    }

    public Integer getOcpxOptimizeSwitch() {
        return ocpxOptimizeSwitch;
    }

    public void setOcpxOptimizeSwitch(Integer ocpxOptimizeSwitch) {
        this.ocpxOptimizeSwitch = ocpxOptimizeSwitch;
    }

    public Integer getOcpxOptimizeType() {
        return ocpxOptimizeType;
    }

    public void setOcpxOptimizeType(Integer ocpxOptimizeType) {
        this.ocpxOptimizeType = ocpxOptimizeType;
    }

    public Long getChannelPkgId() {
        return channelPkgId;
    }

    public void setChannelPkgId(Long channelPkgId) {
        this.channelPkgId = channelPkgId;
    }

    public Integer getImmediatelyRefresh() {
        return immediatelyRefresh;
    }

    public void setImmediatelyRefresh(Integer immediatelyRefresh) {
        this.immediatelyRefresh = immediatelyRefresh;
    }

    public Integer getAdvertiseType() {
        return advertiseType;
    }

    public void setAdvertiseType(Integer advertiseType) {
        this.advertiseType = advertiseType;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }
}
