package com.omni.ads.model.adsgroup;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel("元数据配置返回对象")
public class AdsGroupUpdateInfo implements Serializable {

    private static final long serialVersionUID = 1006588342418402814L;
    /**
     * 计划id
     */
    @ApiModelProperty(value = "广告组id")
    private Long adGroupId;
    /**
     * 计划名称
     */
    @ApiModelProperty(value = "广告组名称")
    private String adGroupName;
    /**
     * 剩余次数
     */
    @ApiModelProperty(value = "剩余修改次数")
    private Integer leftTimes;
    /**
     * 总次数
     */
    @ApiModelProperty(value = "总修改次数")
    private Integer totalTimes;
    /**
     * 更新使否成功 0 成功 1 失败
     */
    @ApiModelProperty(value = "更新是否成功 0-成功 1-失败")
    private int ret;
    /**
     * 失败原因, 冗余信息
     */
    @ApiModelProperty(value = "失败原因")
    private String msg;
    /**
     * 最小价格
     */
    @ApiModelProperty(value = "最小价格")
    private Integer minPrice;
    /**
     * 最大价格
     */
    @ApiModelProperty(value = "最大价格")
    private Integer maxPrice;

    /**
     * 修改类型
     * see @link com.oppo.os.ads.communal.v2.enums.ModifyTypeEnum
     */
    @ApiModelProperty(value = "修改类型")
    private Integer modifyType;

    @ApiModelProperty(value = "更新信息列表")
    private List<AdsGroupUpdateInfo> groupUpdateInfos = Lists.newArrayList();

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public Integer getLeftTimes() {
        return leftTimes;
    }

    public void setLeftTimes(Integer leftTimes) {
        this.leftTimes = leftTimes;
    }

    public Integer getTotalTimes() {
        return totalTimes;
    }

    public void setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
    }

    public int getRet() {
        return ret;
    }

    public void setRet(int ret) {
        this.ret = ret;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    public Integer getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Integer maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Integer getModifyType() {
        return modifyType;
    }

    public void setModifyType(Integer modifyType) {
        this.modifyType = modifyType;
    }

    public List<AdsGroupUpdateInfo> getGroupUpdateInfos() {
        return groupUpdateInfos;
    }

    public void setGroupUpdateInfos(List<AdsGroupUpdateInfo> groupUpdateInfos) {
        this.groupUpdateInfos = groupUpdateInfos;
    }
}

