package com.omni.ads.model.adsinstantapp;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import java.io.Serializable;

/**
 * @ClassName AdInstantAppForm
 * @Author 80233455
 * @Date 2019/1/11 15:23
 * @Version 1.0
 **/

@ApiModel("快应用相关请求对象")
public class AdInstantAppForm implements Serializable  {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "快应用AppId", required = true)
    private Integer instantAppId;

//    @Pattern(regexp = "((hap\\:\\/\\/app\\/|oaps\\:\\/\\/instant\\/app\\/).*)|(^$)")
    @ApiParam(value = "快应用直达链接", hidden = true)
    private String instantAppUrl;

    @ApiParam(value = "状态类别 0：广告，1：广告组，2：计划", required = true)
    @AdRange(values = {0, 1})
    private int type;

    @ApiParam(value = "广告组Id", hidden = true)
    private Long adGroupId;

    @ApiParam(value = "快应用名称，模糊查询", hidden = true)
    private String instantAppNameLike;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getInstantAppId() {
        return instantAppId;
    }

    public void setInstantAppId(Integer instantAppId) {
        this.instantAppId = instantAppId;
    }

    public String getInstantAppUrl() {
        return instantAppUrl;
    }

    public void setInstantAppUrl(String instantAppUrl) {
        this.instantAppUrl = instantAppUrl;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public String getInstantAppNameLike() {
        return instantAppNameLike;
    }

    public void setInstantAppNameLike(String instantAppNameLike) {
        this.instantAppNameLike = instantAppNameLike;
    }
}
