package com.omni.ads.model.adsinstantapp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import java.io.Serializable;

@ApiModel("快应用相关请求对象")
public class AdV3InstantAppForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "快应用AppId", required = true)
    private Integer instantAppId;

    @ApiParam(value = "快应用直达链接", required = true)
    private String instantAppUrl;

    @ApiParam(value = "广告组Id", required = false, hidden = true)
    private Long adGroupId;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getInstantAppId() {
        return instantAppId;
    }

    public void setInstantAppId(Integer instantAppId) {
        this.instantAppId = instantAppId;
    }

    public String getInstantAppUrl() {
        return instantAppUrl;
    }

    public void setInstantAppUrl(String instantAppUrl) {
        this.instantAppUrl = instantAppUrl;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }
}
