package com.omni.ads.model.adsinstantapp;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.omni.ads.model.adsconfig.ApiErrorStruct;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AdsQuickAppResponse implements Serializable {
    @SerializedName("code")
    private int code = 0;

    @SerializedName("msg")
    private String message = null;

    @SerializedName("message_cn")
    private String messageCn = null;

    @SerializedName("errors")
    private List<ApiErrorStruct> errors = null;

    @SerializedName("data")
    private AdInstantAppVo data = null;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public AdsQuickAppResponse message(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get message
     *
     * @return message
     */
    @ApiModelProperty(value = "")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AdsQuickAppResponse messageCn(String messageCn) {
        this.messageCn = messageCn;
        return this;
    }

    /**
     * Get messageCn
     *
     * @return messageCn
     */
    @ApiModelProperty(value = "")
    public String getMessageCn() {
        return messageCn;
    }

    public void setMessageCn(String messageCn) {
        this.messageCn = messageCn;
    }

    public AdsQuickAppResponse errors(List<ApiErrorStruct> errors) {
        this.errors = errors;
        return this;
    }

    public AdsQuickAppResponse addErrorsItem(ApiErrorStruct errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ApiErrorStruct>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    /**
     * Get errors
     *
     * @return errors
     */
    @ApiModelProperty(value = "")
    public List<ApiErrorStruct> getErrors() {
        return errors;
    }

    public void setErrors(List<ApiErrorStruct> errors) {
        this.errors = errors;
    }

    public AdsQuickAppResponse data(AdInstantAppVo data) {
        this.data = data;
        return this;
    }

    /**
     * Get data
     *
     * @return data
     */
    @ApiModelProperty(value = "")
    public AdInstantAppVo getData() {
        return data;
    }

    public void setData(AdInstantAppVo data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdsQuickAppResponse adsUpdateResponse = (AdsQuickAppResponse) o;
        return Objects.equals(this.code, adsUpdateResponse.code)
                && Objects.equals(this.message, adsUpdateResponse.message)
                && Objects.equals(this.messageCn, adsUpdateResponse.messageCn)
                && Objects.equals(this.errors, adsUpdateResponse.errors)
                && Objects.equals(this.data, adsUpdateResponse.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, messageCn, errors, data);
    }

    @Override
    public String toString() {
        Gson gson = new Gson();
        return gson.toJson(this);
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
