package com.omni.ads.model.adsowner;

import com.omni.ads.model.adsgroup.ValidationGroup;
import com.omni.ads.model.adsowner.vo.AdsAgency;
import com.omni.ads.model.adsowner.vo.AdsCustomer;
import com.omni.ads.model.adsowner.vo.AdsOwner;
import com.omni.ads.model.adsowner.vo.OwnerConsts;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;

public class AdsCustomerInfoForm implements Serializable {

    private String ownerName;       // '名称',

    private int ownerType;           // '类型',

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5！@#￥%……&*（）_+-=~<>,./\\|!@#$^《》，。？、）]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 30, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String loginAcc;        //登陆名

    private String loginPsd;        //登陆密码

    private String industryType1;    //一级行业

    private String industryType2;    //二级行业

    private String industryType3;    //三级行业

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 50, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String companyName;      // '公司注册名',

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5！@#￥%……&*（）_+-=~<>,./\\|!@#$^《》，。？、）]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 50, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String customerAddr;     // '联系地址',

    @Pattern(regexp = "^[A-Za-z0-9]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 50, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String orgCode;          // '组织机构代码',

    @Pattern(regexp = "^[A-Za-z0-9]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 50, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String busiLicence;      // '营业执照号',

    @Pattern(regexp = "^[A-Za-z\u4e00-\u9fa5]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 20, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String corporation;      // '法人姓名',

    @Pattern(regexp = "^[A-Za-z0-9]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 18, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String identityCard;     // '身份证号',

    private String identityCardImg;  // '身份证照片',

    private int invoiceType;         // '发票类型  0:普通  1:专用'

    @Pattern(regexp = "^[A-Za-z0-9]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 20, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String taxNum;           // '国税登记号',

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 20, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String bankName;         // '银行名称',

    private String bankCard;         // '银行卡号',

    private String busiLicenceImg;   // '营业执照扫描件',

    private String taxCardImg;         // '税务登记证明'

    private String taxImg;           // '国税登记扫描件',  --暂时被 一般纳税人证明给占用

    private String accPemitImg;         // '开户许可证'

    private String affixInvoiceImg;  // '盖章开票信息扫描件'

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5]+$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(min = 1, max = 50, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String invoiceAddr;      // '邮寄地址',

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5]*$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(max = 20, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String contactName1;     // '联系人姓名1',

    private String contactCompany1;  // '公司岗位1',

    @Pattern(regexp = "^[0-9]*$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(max = 11, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String contactPhone1;    // '手机1',

    private String contactMail1;     // '邮箱1',

    private String contactQq1;       // 'QQ号码1',

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5]*$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(max = 20, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String contactName2;     // '联系人姓名2',

    private String contactCompany2;  // '公司岗位2',

    @Pattern(regexp = "^[0-9]*$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(max = 11, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String contactPhone2;    // '手机2',

    private String contactMail2;     // '邮箱2',

    private String contactQq2;       // 'QQ号码2',

    @Pattern(regexp = "^[A-Za-z0-9\u4e00-\u9fa5]*$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(max = 20, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String contactName3;     // '联系人姓名3',

    private String contactCompany3;  // '公司岗位3',

    @Pattern(regexp = "^[0-9]*$", groups = {ValidationGroup.Add.class, ValidationGroup.Edit.class})
    @Size(max = 11, groups = {ValidationGroup.Edit.class, ValidationGroup.Add.class})
    private String contactPhone3;    // '手机3',

    private String contactMail3;     // '邮箱3',

    private String contactQq3;       // 'QQ号码3',

    public static AdsCustomerInfoForm transfer(AdsOwner owner, AdsCustomer customer) {
        AdsCustomerInfoForm infoForm = new AdsCustomerInfoForm();
        infoForm.setOwnerName(owner.getOwnerName());
        infoForm.setOwnerType(OwnerConsts.OwnerType.ADS_USER);
        infoForm.setLoginAcc(owner.getLoginAcc());
        infoForm.setIndustryType1(owner.getFirstIndustry());
        infoForm.setIndustryType2(owner.getSecondIndustry());
        infoForm.setIndustryType3(owner.getThirdIndustry());
        fillCustomerInfoForm(infoForm, customer);
        return infoForm;
    }

    public static AdsCustomerInfoForm transfer(AdsAgency agency, AdsOwner owner, AdsCustomer customer) {
        AdsCustomerInfoForm infoForm = new AdsCustomerInfoForm();
        infoForm.setOwnerName(agency.getAgencyName());
        infoForm.setOwnerType(OwnerConsts.OwnerType.AGENCY_MASTER);
        infoForm.setLoginAcc(owner.getLoginAcc());
        infoForm.setIndustryType1(owner.getFirstIndustry());
        infoForm.setIndustryType2(owner.getSecondIndustry());
        infoForm.setIndustryType3(owner.getThirdIndustry());
        fillCustomerInfoForm(infoForm, customer);
        return infoForm;
    }

    private static void fillCustomerInfoForm(AdsCustomerInfoForm infoForm, AdsCustomer customer) {
        if (null != customer) {
            BeanUtils.copyProperties(customer, infoForm);
        }
    }

    public static void fillAdsCustomer(AdsCustomer adsCustomer, AdsCustomerInfoForm infoForm) {
        if (null != infoForm) {
            BeanUtils.copyProperties(infoForm, adsCustomer);
        }
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public int getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(int ownerType) {
        this.ownerType = ownerType;
    }

    public String getLoginAcc() {
        return loginAcc;
    }

    public void setLoginAcc(String loginAcc) {
        this.loginAcc = loginAcc;
    }

    public String getLoginPsd() {
        return loginPsd;
    }

    public void setLoginPsd(String loginPsd) {
        this.loginPsd = loginPsd;
    }

    public String getIndustryType1() {
        return industryType1;
    }

    public void setIndustryType1(String industryType1) {
        this.industryType1 = industryType1;
    }

    public String getIndustryType2() {
        return industryType2;
    }

    public void setIndustryType2(String industryType2) {
        this.industryType2 = industryType2;
    }

    public String getIndustryType3() {
        return industryType3;
    }

    public void setIndustryType3(String industryType3) {
        this.industryType3 = industryType3;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCustomerAddr() {
        return customerAddr;
    }

    public void setCustomerAddr(String customerAddr) {
        this.customerAddr = customerAddr;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBusiLicence() {
        return busiLicence;
    }

    public void setBusiLicence(String busiLicence) {
        this.busiLicence = busiLicence;
    }

    public String getCorporation() {
        return corporation;
    }

    public void setCorporation(String corporation) {
        this.corporation = corporation;
    }

    public String getIdentityCard() {
        return identityCard;
    }

    public void setIdentityCard(String identityCard) {
        this.identityCard = identityCard;
    }

    public String getIdentityCardImg() {
        return identityCardImg;
    }

    public void setIdentityCardImg(String identityCardImg) {
        this.identityCardImg = identityCardImg;
    }

    public int getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(int invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }

    public String getBusiLicenceImg() {
        return busiLicenceImg;
    }

    public void setBusiLicenceImg(String busiLicenceImg) {
        this.busiLicenceImg = busiLicenceImg;
    }

    public String getTaxCardImg() {
        return taxCardImg;
    }

    public void setTaxCardImg(String taxCardImg) {
        this.taxCardImg = taxCardImg;
    }

    public String getTaxImg() {
        return taxImg;
    }

    public void setTaxImg(String taxImg) {
        this.taxImg = taxImg;
    }

    public String getAccPemitImg() {
        return accPemitImg;
    }

    public void setAccPemitImg(String accPemitImg) {
        this.accPemitImg = accPemitImg;
    }

    public String getAffixInvoiceImg() {
        return affixInvoiceImg;
    }

    public void setAffixInvoiceImg(String affixInvoiceImg) {
        this.affixInvoiceImg = affixInvoiceImg;
    }

    public String getInvoiceAddr() {
        return invoiceAddr;
    }

    public void setInvoiceAddr(String invoiceAddr) {
        this.invoiceAddr = invoiceAddr;
    }

    public String getContactName1() {
        return contactName1;
    }

    public void setContactName1(String contactName1) {
        this.contactName1 = contactName1;
    }

    public String getContactCompany1() {
        return contactCompany1;
    }

    public void setContactCompany1(String contactCompany1) {
        this.contactCompany1 = contactCompany1;
    }

    public String getContactPhone1() {
        return contactPhone1;
    }

    public void setContactPhone1(String contactPhone1) {
        this.contactPhone1 = contactPhone1;
    }

    public String getContactMail1() {
        return contactMail1;
    }

    public void setContactMail1(String contactMail1) {
        this.contactMail1 = contactMail1;
    }

    public String getContactQq1() {
        return contactQq1;
    }

    public void setContactQq1(String contactQq1) {
        this.contactQq1 = contactQq1;
    }

    public String getContactName2() {
        return contactName2;
    }

    public void setContactName2(String contactName2) {
        this.contactName2 = contactName2;
    }

    public String getContactCompany2() {
        return contactCompany2;
    }

    public void setContactCompany2(String contactCompany2) {
        this.contactCompany2 = contactCompany2;
    }

    public String getContactPhone2() {
        return contactPhone2;
    }

    public void setContactPhone2(String contactPhone2) {
        this.contactPhone2 = contactPhone2;
    }

    public String getContactMail2() {
        return contactMail2;
    }

    public void setContactMail2(String contactMail2) {
        this.contactMail2 = contactMail2;
    }

    public String getContactQq2() {
        return contactQq2;
    }

    public void setContactQq2(String contactQq2) {
        this.contactQq2 = contactQq2;
    }

    public String getContactName3() {
        return contactName3;
    }

    public void setContactName3(String contactName3) {
        this.contactName3 = contactName3;
    }

    public String getContactCompany3() {
        return contactCompany3;
    }

    public void setContactCompany3(String contactCompany3) {
        this.contactCompany3 = contactCompany3;
    }

    public String getContactPhone3() {
        return contactPhone3;
    }

    public void setContactPhone3(String contactPhone3) {
        this.contactPhone3 = contactPhone3;
    }

    public String getContactMail3() {
        return contactMail3;
    }

    public void setContactMail3(String contactMail3) {
        this.contactMail3 = contactMail3;
    }

    public String getContactQq3() {
        return contactQq3;
    }

    public void setContactQq3(String contactQq3) {
        this.contactQq3 = contactQq3;
    }

    public static void formatForm(AdsCustomerInfoForm adsCustomerForm, String fileUrl) {
        if (!StringUtils.isEmpty(adsCustomerForm.getBusiLicenceImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                adsCustomerForm.getBusiLicenceImg().startsWith(fileUrl)) {
            adsCustomerForm.setBusiLicenceImg(adsCustomerForm.getBusiLicenceImg().replace(fileUrl, ""));
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getAccPemitImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                adsCustomerForm.getAccPemitImg().startsWith(fileUrl)) {
            adsCustomerForm.setAccPemitImg(adsCustomerForm.getAccPemitImg().replace(fileUrl, ""));
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getAffixInvoiceImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                adsCustomerForm.getAffixInvoiceImg().startsWith(fileUrl)) {
            adsCustomerForm.setAffixInvoiceImg(adsCustomerForm.getAffixInvoiceImg().replace(fileUrl, ""));
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getIdentityCardImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                adsCustomerForm.getIdentityCardImg().startsWith(fileUrl)) {
            adsCustomerForm.setIdentityCardImg(adsCustomerForm.getIdentityCardImg().replace(fileUrl, ""));
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getTaxCardImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                adsCustomerForm.getTaxCardImg().startsWith(fileUrl)) {
            adsCustomerForm.setTaxCardImg(adsCustomerForm.getTaxCardImg().replace(fileUrl, ""));
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getTaxImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                adsCustomerForm.getTaxImg().startsWith(fileUrl)) {
            adsCustomerForm.setTaxImg(adsCustomerForm.getTaxImg().replace(fileUrl, ""));
        }
    }

    public static void formatVo(AdsCustomerInfoForm adsCustomerForm, String fileUrl) {
        if (!StringUtils.isEmpty(adsCustomerForm.getBusiLicenceImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                !adsCustomerForm.getBusiLicenceImg().startsWith(fileUrl)) {
            adsCustomerForm.setBusiLicenceImg(fileUrl + adsCustomerForm.getBusiLicenceImg());
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getAccPemitImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                !adsCustomerForm.getAccPemitImg().startsWith(fileUrl)) {
            adsCustomerForm.setAccPemitImg(fileUrl + adsCustomerForm.getAccPemitImg());
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getAffixInvoiceImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                !adsCustomerForm.getAffixInvoiceImg().startsWith(fileUrl)) {
            adsCustomerForm.setAffixInvoiceImg(fileUrl + adsCustomerForm.getAffixInvoiceImg());
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getIdentityCardImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                !adsCustomerForm.getIdentityCardImg().startsWith(fileUrl)) {
            adsCustomerForm.setIdentityCardImg(fileUrl + adsCustomerForm.getIdentityCardImg());
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getTaxCardImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                !adsCustomerForm.getTaxCardImg().startsWith(fileUrl)) {
            adsCustomerForm.setTaxCardImg(fileUrl + adsCustomerForm.getTaxCardImg());
        }
        if (!StringUtils.isEmpty(adsCustomerForm.getTaxImg()) &&
                !StringUtils.isEmpty(fileUrl) &&
                !adsCustomerForm.getTaxImg().startsWith(fileUrl)) {
            adsCustomerForm.setTaxImg(fileUrl + adsCustomerForm.getTaxImg());
        }
    }
}

