package com.omni.ads.model.adsowner;

import com.omni.ads.model.adsowner.vo.OwnerConsts;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户信息值对象
 * @author 80122172
 *
 */
@ApiModel("用户信息")
public class AdsOwnerVo {
	/**
	 * 用户id
	 */
	private Long ownerId;

//	/**
//	 * 名称
//	 */
	@ApiModelProperty(value = "ownerName", hidden = true)
	private String ownerName;

	/**
	 * 财务账号id
	 */
	private Long accId;

	/**
	 * 登陆类型
	 */
	private Integer loginType;

	/**
	 * 广告主类型
	 */
	private Integer ownerType;

//	/**
//	 * 代理商登陆等级
//	 */
	@ApiModelProperty(value = "代理商登陆等级", hidden = true)
	private Integer level;

//	/**
//	 * 当前支持的代理商最大等级
//	 */
	@ApiModelProperty(value = "当前支持的代理商最大等级", hidden = true)
	private Integer maxLevel = OwnerConsts.MAX_AGENCY_LEVEL;

	public Long getOwnerId() {
		return ownerId;
	}

	public String getOwnerName() {
		return ownerName;
	}

	public Long getAccId() {
		return accId;
	}

	public Integer getLoginType() {
		return loginType;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
	}

	public void setOwnerName(String ownerName) {
		this.ownerName = ownerName;
	}

	public void setAccId(Long accId) {
		this.accId = accId;
	}

	public void setLoginType(Integer loginType) {
		this.loginType = loginType;
	}

	public Integer getOwnerType() {
		return ownerType;
	}

	public void setOwnerType(Integer ownerType) {
		this.ownerType = ownerType;
	}

	public Integer getLevel() {
		return level;
	}

	public void setLevel(Integer level) {
		this.level = level;
	}

	public Integer getMaxLevel() {
		return maxLevel;
	}

	public void setMaxLevel(Integer maxLevel) {
		this.maxLevel = maxLevel;
	}
}
