package com.omni.ads.model.adsowner.vo;

public class OwnerConsts {
    public static final String MULTI_ACCESS_HEADER_FLAG = "multi-access-id";
    public static final String LOGIN_ACCESS_ID = "login-access-id";
    public static final Integer MAX_AGENCY_LEVEL = 3;

    public OwnerConsts() {
    }

    public interface RelationshipTransStatusCode {
        int NORMAL = 0;
        int DISABLE = 1;
    }

    public interface RelationshipTransResultCode {
        int PROCESSING = 0;
        int SUCCESS = 1;
        int FAILED = 2;
    }

    public interface RelationshipTransTypeCode {
        int MIGRATION = 1;
        int BIND = 2;
        int UNBIND = 3;
    }

    public interface RelationshipTransAuthTypeCode {
        int PROCESSING = 0;
        int AGREE = 1;
        int REJECT = 2;
        int OTHER_REJECT = 3;
    }

    public interface RelationshipTransOwnerTypeCode {
        int SUB_OWNER = 0;
        int MASTER_AGENCY = 1;
        int SUB_AGENCY_LEVEL_2 = 2;
        int SUB_AGENCY_LEVEL_3 = 3;
        int SUB_AGENCY_COMMON = -1;
    }

    public interface OwnerReturnCode {
        Integer CODE_INVALID_INPUT = 10001;
        Integer CODE_UPDATE_DB_FAIL = 10002;
        Integer CODE_EXCEPTION = 40003;
        Integer CODE_QUERY_DB_EMPTY_RESULT = 10004;
    }

    public interface IndustryReturnCode {
        Integer CODE_INVALID_INPUT = 40001;
        Integer CODE_UPDATE_DB_FAIL = 40002;
        Integer CODE_EXCEPTION = 40003;
        Integer CODE_QUERY_DB_EMPTY_RESULT = 40004;
        Integer CODE_PROCESS_EMPTY_RESULT = 40005;
        Integer CODE_ADD_DUPLICATE = 40006;
        Integer CODE_ADD_PARENT_NON_EXIST = 40007;
        Integer CODE_ADD_INVALID_LEVEL = 40008;
        Integer CODE_UPDATE_OWNER_THIRD_FAIL = 40009;
    }

    public interface ReturnMSG {
        String MSG_INVALID_ARGUMENT = "invalid argument input";
        String MSG_INVALID_ID = "valid input with invalid id";
        String MSG_INSERT_DB_FAIL = "insert into db fail";
        String MSG_DB_EXECUTE_FAIL = "db update fail";
        String MSG_EXCEPTION = "exception happen";
        String MSG_EMPTY_DB_QUERY = "query db get empty list";
        String MSG_QUERY_DB_SUCC = "query db succ";
        String MSG_PROCESS_EMPTY_RESULT = "process query industry list ,get empty result";
        String MSG_INSERT_DUPLICATE = "duplicate industry insert";
        String MSG_INSERT_NON_PARENT = "parent do not exist";
        String MSG_INSERT_INVALID_LEVEL = "input level is invalid";
        String MSG_INSERT_SUCC = "insert industry succ";
        String MSG_UPDATE_OWNER_THIRD_INDUSTRY = "update owner third industry fail";
    }

    public interface OminiApiAccessType {
        Integer NOT_AUTHORIZED = 1;
        Integer AUTHORIZED = 2;
    }

    public interface LoginSrc {
        String ADMIN = "admin";
        String OMINI_API = "ominiapi";
    }

    public interface OwnerType {
        int AGENCY_MASTER = 0;
        int AGENCY_SLAVE = 1;
        int OPPO_USER = 2;
        int ADS_USER = 3;
        int OPERATOR = 4;
    }

    public interface OperatorRoleType {
        int ADMIN = 1;
        int EXTENSION = 2;
        int CHARGE = 3;
        int TRANSFER = 4;
        int CUSTOMER_MANAGE = 5;
        int OPERATOR_MANAGE = 6;
    }

    public interface OwnerAuditStatus {
        int AUDITING = 0;
        int AUDITED = 1;
        int REFUSE = 2;
    }

    public interface OwnerDelStatus {
        int NORMAL = 0;
        int DELETED = 1;
    }

    public interface BizLimit {
        int BIZ_CPD = 1;
        int BIZ_SEARCH = 2;
        int BIZ_FEEDS = 4;
        int BIZ_ACTIVTIY = 8;
        int BIZ_UNION = 16;
    }
}
