package com.omni.ads.model.adsplan;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("增加计划表单对象")
public class AdsPlanAddForm implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiParam(value = "计划名称", required = true)
    @NotNull(message = "计划名称 planName 不能为空")
    @Length(max = 100, min = 1, message = "计划名称长度必须在1-100字符之间")
    private String planName;

    @ApiParam(value = "推广目标 1-网页推广 2-应用推广 3-快应用推广", required = true)
    @NotNull(message = "推广目标 extensionType 不能为空")
    @AdRange(values = {1, 2, 3}, message = "推广目标 extensionType 只能在1,2,3中选择")
    private Integer extensionType;

    @ApiParam(value = "日预算 (限制日预算时必填 单位（分）)", required = false)
    private Long dayBudget;

    @ApiParam(value = "是否限制日预算 0 不限制 1 限制, 当dayLimit=1时dayBudget必填", required = true)
    @NotNull(message = "是否限制日预算标识 dayLimit 不能为空")
    @AdRange(values = {0, 1}, message = "是否限制日预算标识 dayLimit 只能在0,1中选择")
    private Integer dayLimit;

    @ApiParam(value = "0-启动 1-暂停", required = false, hidden = true)
    @AdRange(values = {0, 1}, message = "只能新增启动(默认)或暂停状态的计划")
    private Integer status;

    @ApiParam(value = "竞价策略 0-稳定成本 1-最大转化 2-最优成本, 默认为0", hidden = true)
    @AdRange(values = {0, 1, 2}, message = "竞价策略只能设置为稳定成本(0)或最大转化(1)或最优成本(2)")
    private Integer deliveryMode = 0;

    @ApiParam(value = "是否启动匀速投放 0-关闭 1-开启, 默认为0-关闭", hidden = true)
    @AdRange(values = {0, 1}, message = "投放策略只能设置为常规投放(0)或匀速投放(1)")
    private Integer pacingStatus = 0;

    public Integer getDeliveryMode() {
        return deliveryMode;
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public Integer getPacingStatus() {
        return pacingStatus;
    }

    public void setPacingStatus(Integer pacingStatus) {
        this.pacingStatus = pacingStatus;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Long getDayBudget() {
        return dayBudget;
    }

    public void setDayBudget(Long dayBudget) {
        this.dayBudget = dayBudget;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}