package com.omni.ads.model.adsplan;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@ApiModel("计划批量设置或修改日预算表单对象")
public class AdsPlanBudgetForm implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiParam(value = "计划ids 多个id以逗号分隔", required = true)
    @NotEmpty(message = "计划 planIds 不能为空")
    private List<Long> planIds;

    @ApiParam(value = "日预算 (dayLimit=1 时dayBudget必填  单位（分）)", required = false)
    private Long dayBudget;

    @ApiParam(value = "是否限制日预算 0 不限制 1 限制", required = true)
    @NotNull(message = "是否限制日预算标识 dayLimit 不能为空")
    @AdRange(values = {0, 1}, message = "是否限制日预算标识 dayLimit 只能在0,1中选择")
    private Integer dayLimit;

    @ApiParam(value = "设置的预算生效类型，0-日预算，1-次日预算，默认设置日预算")
    @AdRange(values = {0, 1}, message = "设置的预算生效类型 effectiveType 只能在0,1中选择")
    private Integer effectiveType = 0;

    public Integer getEffectiveType() {
        return effectiveType;
    }

    public void setEffectiveType(Integer effectiveType) {
        this.effectiveType = effectiveType;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<Long> getPlanIds() {
        return planIds;
    }

    public void setPlanIds(List<Long> planIds) {
        this.planIds = planIds;
    }

    public Long getDayBudget() {
        return dayBudget;
    }

    public void setDayBudget(Long dayBudget) {
        this.dayBudget = dayBudget;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }
}