package com.omni.ads.model.adsplan;

import com.omni.ads.anno.AdRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("计划批量修改表单对象")
public class AdsPlanEditForm implements Serializable {

    @ApiParam(value = "计划id (修改单个广告使用)", required = true)
    @NotNull(message = "计划 planId 不能为空")
    private Long planId;

    @ApiParam(value = "计划名称 (修改名称时必传)", required = false)
    @Length(max = 100, min = 1, message = "计划名称长度必须在1-100字符之间")
    private String planName;

    @ApiParam(value = "日预算 (dayLimit=1 时dayBudget必填 必须为整数 单位（分）)", required = false)
    private Long dayBudget;

    @ApiParam(value = "是否限制日预算 0 不限制 1 限制 (修改预算时必传)", required = false)
    @NotNull(message = "是否限制日预算标识 dayLimit 不能为空")
    @AdRange(values = {0, 1}, message = "是否限制日预算标识 dayLimit 只能在0,1中选择")
    private Integer dayLimit;

    @ApiParam(value = "是否启动匀速投放 0-关闭 1-开启", hidden = true)
    @AdRange(values = {0, 1}, message = "投放策略只能设置为常规投放(0)或匀速投放(1)")
    private Integer pacingStatus;

    public Integer getPacingStatus() {
        return pacingStatus;
    }

    public void setPacingStatus(Integer pacingStatus) {
        this.pacingStatus = pacingStatus;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Long getDayBudget() {
        return dayBudget;
    }

    public void setDayBudget(Long dayBudget) {
        this.dayBudget = dayBudget;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }
}